#!/bin/bash
# USAGE: ./solver.sh INPUTFILE TIME_LIMIT
infile=$1
time_limit=$2

if [ "$time_limit" == "" ]; then
    echo "USAGE: ./solver.sh INPUTFILE TIME_LIMIT"
    exit
fi

ulimit -t $time_limit
ulimit -S -s 262144
python cqbf-conv.py $infile --quiet | ./ghostq - -s-cnf -q2 -pt -time-out $time_limit -cegar 0
ex=$?

exit $ex
