#!/bin/bash
# USAGE: ./solver.sh INPUTFILE TIME_LIMIT
infile=$1
time_limit=$2

if [ "$time_limit" == "" ]; then
    echo "USAGE: ./solver.sh INPUTFILE TIME_LIMIT"
    exit
fi

ulimit -t $time_limit
ulimit -S -s 262144
bash ./qcir-to-gq.sh $infile | ./ghostq - -s-cnf -q2 -pt -time-out $time_limit -cegar 1
ex=$?

exit $ex
