/*
 * Decompiled with CFR 0.152.
 */
package test;

import android.content.res.AXmlResourceParser;
import java.io.FileInputStream;

public class AXMLPrinter {
    private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.051758E-5f, 1.192093E-7f, 4.656613E-10f};
    private static final String[] DIMENSION_UNITS = new String[]{"px", "dip", "sp", "pt", "in", "mm", "", ""};
    private static final String[] FRACTION_UNITS = new String[]{"%", "%p", "", "", "", "", "", ""};

    public static void main(String[] arguments) {
        if (arguments.length < 1) {
            AXMLPrinter.log("Usage: AXMLPrinter <binary xml file>", new Object[0]);
            return;
        }
        try {
            int type;
            AXmlResourceParser parser = new AXmlResourceParser();
            parser.open(new FileInputStream(arguments[0]));
            StringBuilder indent = new StringBuilder(10);
            String indentStep = "\t";
            while ((type = parser.next()) != 1) {
                switch (type) {
                    case 0: {
                        AXMLPrinter.log("<?xml version=\"1.0\" encoding=\"utf-8\"?>", new Object[0]);
                        break;
                    }
                    case 2: {
                        AXMLPrinter.log("%s<%s%s", indent, AXMLPrinter.getNamespacePrefix(parser.getPrefix()), parser.getName());
                        indent.append("\t");
                        int namespaceCountBefore = parser.getNamespaceCount(parser.getDepth() - 1);
                        int namespaceCount = parser.getNamespaceCount(parser.getDepth());
                        int i = namespaceCountBefore;
                        while (i != namespaceCount) {
                            AXMLPrinter.log("%sxmlns:%s=\"%s\"", indent, parser.getNamespacePrefix(i), parser.getNamespaceUri(i));
                            ++i;
                        }
                        i = 0;
                        while (i != parser.getAttributeCount()) {
                            AXMLPrinter.log("%s%s%s=\"%s\"", indent, AXMLPrinter.getNamespacePrefix(parser.getAttributePrefix(i)), parser.getAttributeName(i), AXMLPrinter.getAttributeValue(parser, i));
                            ++i;
                        }
                        AXMLPrinter.log("%s>", indent);
                        break;
                    }
                    case 3: {
                        indent.setLength(indent.length() - "\t".length());
                        AXMLPrinter.log("%s</%s%s>", indent, AXMLPrinter.getNamespacePrefix(parser.getPrefix()), parser.getName());
                        break;
                    }
                    case 4: {
                        AXMLPrinter.log("%s%s", indent, parser.getText());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getNamespacePrefix(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return "";
        }
        return String.valueOf(prefix) + ":";
    }

    public static String getAttributeValue(AXmlResourceParser parser, int index) {
        int type = parser.getAttributeValueType(index);
        int data = parser.getAttributeValueData(index);
        if (type == 3) {
            return parser.getAttributeValue(index);
        }
        if (type == 2) {
            return String.format("?%s%08X", AXMLPrinter.getPackage(data), data);
        }
        if (type == 1) {
            return String.format("@%s%08X", AXMLPrinter.getPackage(data), data);
        }
        if (type == 4) {
            return String.valueOf(Float.intBitsToFloat(data));
        }
        if (type == 17) {
            return String.format("0x%08X", data);
        }
        if (type == 18) {
            return data != 0 ? "true" : "false";
        }
        if (type == 5) {
            return String.valueOf(Float.toString(AXMLPrinter.complexToFloat(data))) + DIMENSION_UNITS[data & 0xF];
        }
        if (type == 6) {
            return String.valueOf(Float.toString(AXMLPrinter.complexToFloat(data))) + FRACTION_UNITS[data & 0xF];
        }
        if (type >= 28 && type <= 31) {
            return String.format("#%08X", data);
        }
        if (type >= 16 && type <= 31) {
            return String.valueOf(data);
        }
        return String.format("<0x%X, type 0x%02X>", data, type);
    }

    public static String getPackage(int id) {
        if (id >>> 24 == 1) {
            return "android:";
        }
        return "";
    }

    public static void log(String format, Object ... arguments) {
        System.out.printf(format, arguments);
        System.out.println();
    }

    public static float complexToFloat(int complex) {
        return (float)(complex & 0xFFFFFF00) * RADIX_MULTS[complex >> 4 & 3];
    }
}

