function [x, y, i, flag] = VonNeumann(A, epsilon, maxIter, checkFreq)

fprintf('\n');
flag = 0;
[m, n] = size(A);
x = ones(n,1)/n;
y = A*x;

for i = 1 : maxIter
    temp = A'*y;
    [minVal, idx] = min(temp);
    if mod(i, checkFreq) == 0
        fprintf('min value of A''y: %f\n', minVal);
    end
    
    % when DFP is feasible
    if minVal > 0
        flag = 1;
        fprintf('DFP is feasible!\nIterations: %d\n', i);
        break;
    end
    
     

    lambda = i/(i+1);
    s = zeros(n, 1);
    s(idx) = 1;
    x = lambda*x + (1-lambda)*s;
    y = lambda*y + (1-lambda)*A(:,idx);
    
    % why does this lambda fail???
%     lambda = (1-minVal) / (y'*y - 2*minVal + 1);
%     s = zeros(n, 1);
%     s(idx) = 1;
%     x = lambda*x + (1-lambda)*s;
%     y = lambda*y + (1-lambda)*A(:,idx);
    
    yNorm = norm(y,2);    
    if mod(i, checkFreq) == 0
        fprintf('||Ax|| = %f\n', yNorm);     
    end
    % when AP is feasible
    if yNorm <= epsilon
        flag = 2;
        fprintf('AP is eps-feasible!\nIterations: %d\n', i);
        break;
    end

    
end



if flag == 0
    fprintf('\nExceed maximum iteration number. Could not find a solution!\n');
end







