function [g, nIter] = TrainClassifier(labelTrain, KTrainTrain, param)


% homogeneous processing
KTrainTrainNew = KTrainTrain .* bsxfun(@times, labelTrain', labelTrain);

checkFreq = param.checkFreq;
epsilon = param.epsilon;
maxIter = param.maxIter;

if isequal(param.name, 'KMP') 
    fprintf('\n\n******** Running Kernelized Mirror Prox ********\n\n');   
    z0 = param.z0;
    Lxy = param.Lxy;
    Lyx = param.Lyx;
    omegaX = param.omegaX;
    omegaY = param.omegaY;
    [x, g, nIter, flag] = MirrorProxKernel(z0, KTrainTrainNew, Lxy, Lyx, omegaX, omegaY, epsilon, maxIter, checkFreq);
    fprintf('(# of K*gKMP>0) = %d\n', sum(KTrainTrainNew*g>0));
    fprintf('||xKMP*K*xKMP|| = %d\n', x'*KTrainTrainNew*x);
elseif isequal(param.name, 'KISPVN')   
    fprintf('\n\n******** Running Kernelized ISPVN ********\n\n');
    r = param.r;
    maxIterInner = param.maxIterInner;
%     [x, g, nIter, flag] = ISPVNKernel(KTrainTrainNew, r, epsilon, maxIter, maxIterInner, checkFreq);
    [x, g, nIter, flag] = ISPVNKernelCIFAR(KTrainTrainNew, r, epsilon, maxIter, maxIterInner, checkFreq);
    fprintf('(# of K*gKISPVN>0) = %d\n', sum(KTrainTrainNew*g>0));
    fprintf('sqrt(xKISPVN''*K*xKISPVN) = %d\n', sqrt(x'*KTrainTrainNew*x));
elseif isequal(param.name, 'KP')
    fprintf('\n\n******** Running Kernelized Perceptron ********\n\n');
    [g, nIter, flag] = PerceptronKernel(KTrainTrainNew, maxIter, checkFreq);
    fprintf('(# of K''*gKPCT>0) = %d\n', sum(KTrainTrainNew*g>0));
elseif isequal(param.name, 'KVN')
    fprintf('\n\n******** Running Kernelized von-Neumann ********\n\n');
    [x, g, nIter, flag] = VonNeumannKernel(KTrainTrainNew, epsilon, maxIter, checkFreq);
    fprintf('(# of K''*gKPCT>0) = %d\n', sum(KTrainTrainNew*g>0));
    fprintf('sqrt(xKVN''*K*xKVN) = %d\n', sqrt(x'*KTrainTrainNew*x));
else
    error('Wrong Training Method!');
end


% inverse the negative example
negIdx = labelTrain==-1;
g(negIdx) = -g(negIdx);
