%% setup

clear;
% system('hostname');
% maxNumCompThreads(1);

% m is the data dimension and n is the number of data
m = 100;
n = 5000;
maxIter = 1e6;
epsilon = 1e-3;

% the larger the abs(kappa), the more feasible the problem is
% the closer kappa is to 0, the more infeasible the problem is
kappa = 1;


nTest = 1;

% the data matrix A is normalized
isNormal = true;

for i = 1 : nTest
    A = GenerateA(m, n, kappa, isNormal);
    
    %% Mirror Prox
    for ii = [1]
        z0 = [ones(n,1)/n; zeros(m,1)];        
        checkFreqMP = 100;
        Lxy = 1;
        Lyx = 1;
        omegaX = log(n);
        omegaY = 0.5;
        
        fprintf('\n\n******** Running Mirror Prox ********\n\n');
        tic;
        [xMP, yMP, nIterMP(i), flagMP(i)] = MirrorProx(z0, A, Lxy, Lyx, omegaX, omegaY, epsilon, maxIter, checkFreqMP, isNormal);
        runtimeMP(i) = toc,
        nIterMP,
        flagMP,
        fprintf('(# of A''*yMP>0) = %d\n', sum(A'*yMP>0));
        fprintf('||A*xMP|| = %d\n', norm(A*xMP,2));       
        
        
    end
    
    
    
    %% ISPVN
    for ii = [1]
        
        fprintf('\n\n******** Running ISPVN ********\n\n');
        r = 2;
        checkFreqISPVN = 100;
        maxIterInner = 10000;
        tic;
        [xISPVN, yISPVN, nIterISPVN(i), flagISPVN(i)] = ISPVN(A, r, epsilon, maxIter, maxIterInner, checkFreqISPVN);
        runtimeISPVN(i) = toc,
        nIterISPVN,
        flagISPVN,
        fprintf('(# of A''*yISPVN>0) = %d\n', sum(A'*yISPVN>0));
        fprintf('||A*xISPVN|| = %d\n', norm(A*xISPVN,2));
     
    end
    
    
    %% Smooth Perceptron
    for ii = [1]
        fprintf('\n\n******** Running Smooth Perceptron ********\n\n');
                checkFreqSPCT = 100;
        tic;
        [ySPCT, nIterSPCT(i), flagSPCT(i)] = SmoothPerceptron(A, maxIter, checkFreqSPCT);
        runtimeSPCT(i) = toc,
        nIterSPCT,
        flagSPCT,
        fprintf('(# of A''*ySPCT>0) = %d\n', sum(A'*ySPCT>0));
        
        
    end
    
    
    
    %% Perceptron
    for ii = [1]
        
        fprintf('\n\n******** Running Perceptron ********\n\n');
        checkFreqPCT = 1e4;
        tic;
        [yPCT, nIterPCT(i), flagPCT(i)] = Perceptron(A, maxIter, checkFreqPCT);
        runtimePCT(i) = toc,
        nIterPCT,
        flagPCT,
        fprintf('(# of A''*yPCT>0) = %d\n', sum(A'*yPCT>0));
        

        
        
    end
    
    
    
    %% von-Neumann
    for ii = [1]
        fprintf('\n\n******** Running von-Neumann ********\n\n');
        
        checkFreqVN = 1e4;
        tic;
        [xVN, yVN, nIterVN(i), flagVN(i)] = VonNeumann(A, epsilon, maxIter, checkFreqVN);
        runtimeVN(i) = toc,
        nIterVN,
        flagVN,
        fprintf('(# of A''*yVN>0) = %d\n', sum(A'*yVN>0));
        fprintf('||A*xVN|| = %d\n', norm(A*xVN,2));
        
        
    end
    

    fprintf('\n\nMeaning of flag:\n');
    fprintf('flag=1 : DFP is feasible and algorithms succeeds.\n');
    fprintf('flag=2 : AP is epsilon-feasible and algorithms succeeds.\n');   
    fprintf('flag=0 : Algorithm fails\n\n');

    
    
end

























