% addpath(genpath('../code'));
clear;
% system('hostname');
% maxNumCompThreads(1);

% resultPath = 'result/';


% clc;
%% setup
ntrain = 10000;
ntest = 10000;
data_dir = 'data/cifar-10-batches-mat';
trainBatch = 'data_batch_1.mat';
testBatch = 'test_batch.mat';
isNormal = true;
load(fullfile(data_dir,trainBatch));
tr_labels = labels;
tr_feats = double(data);
load(fullfile(data_dir,testBatch));
te_labels = labels;
te_feats = double(data);
norm_type = 'l2';
tr_feats = normalize_data(tr_feats,norm_type);
te_feats = normalize_data(te_feats,norm_type);


kernelParam.name = 'rbf';
kernelParam.gamma = 5.5;

%the kernel should add an intersection term of all ones
KTrainTrain = Kernel(double(tr_feats), double(tr_feats), kernelParam) + ones(ntrain,ntrain);

% the maximum iteration to train each classifier
param.maxIter = 100;

param.epsilon = 1e-9;
param.checkFreq = 50;

trainTimeKMP=0;
trainTimeKISPVN=0;
trainTimeKP=0;
trainTimeKVN=0;

accKMP=0;
accKISPVN=0;
accKP=0;
accKVN=0;


nIterKMP=0;
nIterKISPVN=0;
nIterKP=0;
nIterKVN=0;

%% Kernelized Mirror Prox
for ii = [1]
    fprintf('\n\n --- Kernelized Mirror Prox --- \n');

    param.name = 'KMP';
    param.z0 = [ones(ntrain,1)/ntrain; zeros(ntrain,1)];
    param.Lxy = 1;
    param.Lyx = 1;
    param.omegaX = log(ntrain);
    param.omegaY = 0.5;
      
        
    %% Training
    tic;
    [modelKMP, nIterKMP] = MyTrainModels(tr_labels, tr_feats, KTrainTrain, param);
    trainTimeKMP = toc;

    %% Testing
    % the kernel should add an intersection term of all ones
    KTestTrain = Kernel(double(te_feats), double(tr_feats), kernelParam) + ones(ntest, ntrain);
    classid = unique(te_labels);
    score = zeros(ntest, length(classid));
    for i = 1 : length(classid)
        score(:, i) = KTestTrain * modelKMP{i}.g;
    end
    [maxValue, predictLabel] = max(score, [], 2);
    predictLabel = predictLabel - 1;
    nCorrect = sum(predictLabel==te_labels);
    accKMP = nCorrect /  ntest;
    
    % release KTestTrain to save space
    KTestTrain = [];
end



%% Kernelized ISPVN
for ii = [1]
    fprintf('\n\n --- Kernelized ISPVN --- \n');
        
    param.name = 'KISPVN';
    param.r = 2;
    param.maxIterInner = 1000;
    
    %% Training
    tic;
    [modelISPVN, nIterKISPVN] = MyTrainModels(tr_labels, tr_feats, KTrainTrain, param);
    trainTimeKISPVN = toc;
    
    %% Testing
    % the kernel should add an intersection term of all ones
    KTestTrain = Kernel(double(te_feats), double(tr_feats), kernelParam) + ones(ntest, ntrain);

    classid = unique(te_labels);
    score = zeros(ntest, length(classid));
    for i = 1 : length(classid)
        score(:, i) = KTestTrain * modelISPVN{i}.g;
    end
    [maxValue, predictLabel] = max(score, [], 2);
    predictLabel = predictLabel - 1;
    nCorrect = sum(predictLabel==te_labels);
    accKISPVN = nCorrect /  ntest;
    
    % release KTestTrain to save space
    KTestTrain = [];
end




%% Kernelized Perceptron
for ii = [1]
    fprintf('\n\n --- Kernelized Perceptron --- \n');
        
    param.name = 'KP';

    %% Training
    tic;
    [modelKP, nIterKP]= MyTrainModels(tr_labels, tr_feats, KTrainTrain, param);
    trainTimeKP = toc;
    
    %% Testing
    % the kernel should add an intersection term of all ones
    KTestTrain = Kernel(double(te_feats), double(tr_feats), kernelParam) + ones(ntest, ntrain);

    classid = unique(te_labels);
    score = zeros(ntest, length(classid));
    for i = 1 : length(classid)
        score(:, i) = KTestTrain * modelKP{i}.g;
    end
    [maxValue, predictLabel] = max(score, [], 2);
    predictLabel = predictLabel - 1;
    nCorrect = sum(predictLabel==te_labels);
    accKP = nCorrect /  ntest;
    
    % release KTestTrain to save space
    KTestTrain = [];
end




%% Kernelized von-neumann
for ii = [1]
    fprintf('\n\n --- Kernelized von-Neumann --- \n');
        
    param.name = 'KVN';

    %% Training
    tic;
    [modelKVN, nIterKVN]= MyTrainModels(tr_labels, tr_feats, KTrainTrain, param);
    trainTimeKVN = toc;
    
    %% Testing
    % the kernel should add an intersection term of all ones
    KTestTrain = Kernel(double(te_feats), double(tr_feats), kernelParam) + ones(ntest, ntrain);

    classid = unique(te_labels);
    score = zeros(ntest, length(classid));
    for i = 1 : length(classid)
        score(:, i) = KTestTrain * modelKVN{i}.g;
    end
    [maxValue, predictLabel] = max(score, [], 2);
    predictLabel = predictLabel - 1;
    nCorrect = sum(predictLabel==te_labels);
    accKVN = nCorrect /  ntest;
    
    % release KTestTrain to save space
    KTestTrain = [];
end

KTrainTrain = [];
tr_feats = [];
te_feats = [];
data = [];
score = [];


trainTimeKMP,
trainTimeKISPVN,
trainTimeKP,
trainTimeKVN,

accKMP,
accKISPVN,
accKP,
accKVN,

nIterKMP,
nIterKISPVN,
nIterKP,
nIterKVN,


% save([resultPath, 'CIFAR_iter_', num2str(param.maxIter), '.mat']);











































