function [g, i, flag] =  SmoothPerceptronKernel(K, maxIter, checkFreq)

fprintf('\n');
flag = 0;
n = size(K, 1);

mu = 1;
% y = A*ones(n,1)/n;
g = ones(n,1)/n;
x = XMuGSmooth(g, K, mu);



for i = 1 : maxIter
    theta = 2/(i+3);
    g = (1-theta)*(g+theta*(x)) + theta^2*(XMuGSmooth(g, K, mu));
    mu = (1-theta)*mu;
    x = (1-theta)*x + theta*XMuGSmooth(g, K, mu);
    
    temp = K*g;
    nNeg = sum(temp<=0);
    if  nNeg == 0
        flag = 1;
        fprintf('DFP is feasible!\nIterations: %d\n', i);
        break;
    end
    if mod(i, checkFreq) == 0
        fprintf('nNeg: %d\n', nNeg);
    end
end


if flag == 0
    fprintf('\nExceed maximum iteration number. Could not find a solution!\n');
end