function [y, i, flag] =  SmoothPerceptron(A, maxIter, checkFreq)

fprintf('\n');
flag = 0;
[m, n] = size(A);

mu = 1;
y = A*ones(n,1)/n;
x = XMuYSmooth(y, A, mu);



for i = 1 : maxIter
    theta = 2/(i+3);
    y = (1-theta)*(y+theta*(A*x)) + theta^2*(A*XMuYSmooth(y, A, mu));
    mu = (1-theta)*mu;
    x = (1-theta)*x + theta*XMuYSmooth(y, A, mu);
    
    if sum(isnan(y))
        fprintf('Smooth Perceptron Fails!')
        break;
    else        
        temp = A'*y;
        nNeg = sum(temp<=0);        
        if  nNeg == 0
            flag = 1;
            fprintf('DFP is feasible!\nIterations: %d\n', i);
            break;
        end        
    end
    if mod(i, checkFreq) == 0
        fprintf('nNeg: %d\n', nNeg);
    end
end


if flag == 0
    if i == maxIter
        fprintf('\nExceed maximum iteration number. Could not find a solution!\n');
    end
end