function [x, g, i, flag] = SPVNKernel(xBar, K, delta, maxIter, checkFreq)

fprintf('\n');
flag = 0;
n = size(K, 1);
mu = 2*n;
g = xBar;
x = XMuG(g, K, xBar, mu);
AxNorm = sqrt(x'*K*x);

for i = 1 : maxIter
    theta = 2/(i+3);
    g = (1-theta)*(g+theta*(x)) + theta^2*(XMuG(g, K, xBar, mu));
    mu = (1-theta)*mu;
    x = (1-theta)*x + theta*XMuG(g, K, xBar, mu);
    
    temp = K*g;
    nNeg = sum(temp<=0);
    if nNeg == 0
        flag = 1;
        fprintf('Inner DFP is feasible!\nIterations: %d\n', i);
        break;
    end
    
    AxNormNew = sqrt(x'*K*x);
    if AxNormNew < delta
        flag = 2;
        fprintf('Inner AP is delta-feasible!\nIterations: %d\n', i);
        break;
    elseif abs(AxNorm-AxNormNew) < 1e-5
        flag = 3;
        fprintf('Inner AxNorm does not change!\nIterations: %d\n', i);
        break;
    end
    
    AxNorm = AxNormNew;

    if mod(i, checkFreq) == 0
        fprintf('nNeg = %d\n', nNeg);
        fprintf('AxNorm = %f\n', AxNorm);
    end
    
end


if flag == 0
    fprintf('\nExceed maximum iteration number. Could not find a solution!\n');
end







