function [x, y, i, flag] = SPVN(xBar, A, delta, maxIter, checkFreq)

fprintf('\n');
flag = 0;
[m, n] = size(A);
mu = 2*n;
y = A*xBar;
x = XMuY(y, A, xBar, mu);
AxNorm = norm(A*x,2);

for i = 1 : maxIter
    theta = 2/(i+3);
    y = (1-theta)*(y+theta*(A*x)) + theta^2*(A*XMuY(y, A, xBar, mu));
    mu = (1-theta)*mu;
    x = (1-theta)*x + theta*XMuY(y, A, xBar, mu);
    
    temp = A'*y;
    nNeg = sum(temp<=0);
    if nNeg == 0
        flag = 1;
        fprintf('Inner DFP is feasible!\nIterations: %d\n', i);
        break;
    end
    
    AxNormNew = norm(A*x,2);    
    if AxNormNew < delta
        flag = 2;
        fprintf('Inner AP is delta-feasible!\nIterations: %d\n', i);
        break;
    elseif abs(AxNorm-AxNormNew) < 1e-5
        flag = 3;
        fprintf('Inner AxNorm does not change!\nIterations: %d\n', i);
        break;
    end
    
    AxNorm = AxNormNew;
    
    if mod(i, checkFreq) == 0
        fprintf('nNeg = %d\n', nNeg);
        fprintf('AxNorm = %f\n', AxNorm);
    end
    
end


if flag == 0
    fprintf('\nExceed maximum iteration number. Could not find a solution!\n');
end







