function y = ProxMapKernel(x, z, K, type)
% z is the center and x is the point to be mapped

if isequal(type, 'eb_euclidean')
    % Euclidean ball
    y = z - x;
    yNorm = sqrt(y'*K*y);
    if yNorm > 1
        y = y / yNorm;
    end        
else
    error('Error Prox Mapping Type!');
end