function y = ProxMap(x, z, type)
% z is the center and x is the point to be mapped

if isequal(type, 'simplex_entropy')
    % Simplex
    y = z.*exp(-x);
    y = y/sum(y);
elseif isequal(type, 'eb_euclidean')
    % Euclidean ball
    y = z - x;
    yNorm = norm(y,2);
    if yNorm > 1
        y = y / yNorm;
    end        
else
    error('Error Prox Mapping Type!');
end