% trains multiclass SVM models using 1-vs-all classifiers
function [model, totalIter] = MyTrainModels(tr_labels,tr_feats, KTrainTrain, param)

% n = length(tr_labels);
% 
% %the kernel should an intersection term of all ones
% KTrainTrain = Kernel(tr_feats, tr_feats, kernelParam) + ones(n,n);

totalIter = 0;
classid = unique(sort(tr_labels));
ntrain  = size(tr_feats,1);
ndim    = size(tr_feats,2);

fprintf('\n Training Classifiers using %s with %i examples (feat dim=%i).\n', param.name,ntrain,ndim);

for i = 1:length(classid),
    npos = sum(tr_labels==classid(i));
    nneg = ntrain - npos;
    
    labelTrain = double(tr_labels==classid(i));
    labelTrain(labelTrain==0) = -1;
    
    fprintf('\nTraining for class : %d, ',classid(i));
    fprintf('\t %d+/%d- \n',npos,nneg);
    
    [model{i}.g, nIter] = TrainClassifier(labelTrain, KTrainTrain, param);
    totalIter = totalIter + nIter;


end
