function [solt1, solt2, i, flag] = MirrorProxKernel(z0, K,...
    Lxy, Lyx, omegaX, omegaY, epsilon, maxIter, checkFreq)
% Applying MirrorProx to the kernelized saddle point problem
% flag = 0 ==> not solution found
% flag = 1 ==> DFP feasible;
% flag = 2 ==> AP epsilon-feasible;
% z0 is the initial center
% K is the kernel matrix 

fprintf('\n');
flag = 0;
n = size(K,1);

% initialize prox-mapping center
xt = z0(1 : n);
% yt = z0(n+1 : n+m);
gt = z0(n+1 : 2*n);

solt1 = zeros(size(xt));
% solt2 = zeros(size(yt));
solt2 = zeros(size(gt));


% A'*y and A*x
% K_g = A'*solt2;
% A_x = -(A*solt1);


L = Lxy*sqrt(omegaX) + Lyx*sqrt(omegaY);
alphaX = Lxy / (sqrt(omegaX) * L);
alphaY = Lyx / (sqrt(omegaY) * L);


gamma = 1/L;


% we suppose the data in the kernel space is normalized 
% i.e. the diagnal of the kernel matrix is ones,
% otherwise, gamma1=gamma2=gamma
gamma1 = gamma/alphaX;
gamma2 = gamma/alphaY;



if ~exist('checkFreq', 'var')
    checkFreq = 10;
end


i = 0;
while i < maxIter
    i = i + 1;
    
    % update iterated point
%     wt1 = ProxMap((gamma/alphaX)*(K*gt), xt, 'simplex_entropy');
%     wt2 = ProxMapKernel(-(gamma/alphaY*xt), gt, K, 'eb_euclidean');
    wt1 = ProxMap(gamma1*(K*gt), xt, 'simplex_entropy');
    wt2 = ProxMapKernel(-(gamma2*xt), gt, K, 'eb_euclidean');
     
    % incremental update solution, we assume gamma is constant
    solt1 = (i-1)/i * solt1 + 1/i * wt1;
    solt2 = (i-1)/i * solt2 + 1/i * wt2;

    
    % check if DFP is feasible
    lb = min(K*solt2);
    if lb > 0
%         solt2 = solt2 / norm(solt2,2);
        flag = 1;
        fprintf('DFP is feasible!\nIterations: %d\n', i);
        break;
    end
    
    % check if AP is epsilon-feasible
    ub = sqrt(solt1'*K*solt1);
    if ub <= epsilon
        flag = 2;
        fprintf('AP is eps-feasible!\nIterations: %d\n', i);
        break;
    end
    
    if mod(i, checkFreq) == 0        
        fprintf('lb =  %f\n', lb);
        fprintf('ub = %f\n', ub);
    end
    
    % update prox-mapping center
    xt = ProxMap(gamma1*(K*wt2), xt, 'simplex_entropy');
    gt = ProxMapKernel(-(gamma2*wt1), gt, K, 'eb_euclidean'); 
%     xt = ProxMap((gamma/alphaX)*(K*wt2), xt, 'simplex_entropy');
%     gt = ProxMapKernel(-(gamma/alphaY*wt1), gt, K, 'eb_euclidean');
%         xt = ProxMap(gamma*Gt1, xt, 'simplex_entropy');
%     yt = ProxMap(gamma*Gt2, yt, 'eb_euclidean');   
    
end

if flag == 0
    fprintf('\nExceed maximum iteration number. Could not find a solution!\n');
end





























