function [solt1, solt2, i, flag] = MirrorProx(z0, A,...
    Lxy, Lyx, omegaX, omegaY, epsilon, maxIter, checkFreq, isNormal)
% Applying MirrorProx to the saddle point problem
% flag = 0 ==> not solution found
% flag = 1 ==> DFP feasible;
% flag = 2 ==> AP epsilon-feasible;
% z0 is the initial center

fprintf('\n');
flag = 0;
[m,n] = size(A);

% initializztion
xt = z0(1 : n);
yt = z0(n+1 : n+m);

solt1 = zeros(size(xt));
solt2 = zeros(size(yt));

At_y = A'*solt2;
A_x = -(A*solt1);

L = Lxy*sqrt(omegaX) + Lyx*sqrt(omegaY);
alphaX = Lxy / (sqrt(omegaX) * L);
alphaY = Lyx / (sqrt(omegaY) * L);


gamma = 1/L;

if isNormal
    gamma1 = gamma/alphaX;
    gamma2 = gamma/alphaY;
else
    gamma1 = gamma;
    gamma2 = gamma;
end

if ~exist('checkFreq', 'var')
    checkFreq = 10;
end


i = 0;
while i < maxIter
    i = i + 1;
    
    % update iterated point
    Ft1 = A'*yt;
    Ft2 = -(A*xt);
    wt1 = ProxMap(gamma1*Ft1, xt, 'simplex_entropy');
    wt2 = ProxMap(gamma2*Ft2, yt, 'eb_euclidean');
%     wt1 = ProxMap((gamma/alphaX)*Ft1, xt, 'simplex_entropy');
%     wt2 = ProxMap((gamma/alphaY)*Ft2, yt, 'eb_euclidean');
    
    % incremental update solution, we assume gamma is constant
    solt1 = (i-1)/i * solt1 + 1/i * wt1;
    solt2 = (i-1)/i * solt2 + 1/i * wt2;
    
    % calculate new gradient of the new iterate
    Gt1 = A'*wt2;
    Gt2 = -(A*wt1);
    
    % incremental update A'y and Ax
    At_y = (i-1)/i * At_y + 1/i * Gt1;
    A_x = (i-1)/i * A_x - 1/i * Gt2;
    
    
    % check if DFP is feasible
    lb = min(At_y);
    if lb > 0
        solt2 = solt2 / norm(solt2,2);
        flag = 1;
        fprintf('DFP is feasible!\nIterations: %d\n', i);
        break;
    end
    
    % check if AP is epsilon-feasible
    ub = norm(A_x, 2);
    if ub <= epsilon
        flag = 2;
        fprintf('AP is eps-feasible!\nIterations: %d\n', i);
        break;
    end
    
    if mod(i, checkFreq) == 0        
        fprintf('lb = %f\n', lb);
        fprintf('ub = %f\n', ub);
    end
    
    % update prox-mapping center
    xt = ProxMap(gamma1*Gt1, xt, 'simplex_entropy');
    yt = ProxMap(gamma2*Gt2, yt, 'eb_euclidean');   
%     xt = ProxMap((gamma/alphaX)*Gt1, xt, 'simplex_entropy');
%     yt = ProxMap((gamma/alphaY)*Gt2, yt, 'eb_euclidean');
    
end

if flag == 0
    fprintf('\nExceed maximum iteration number. Could not find a solution!\n');
end





























