function K = Kernel(X1, X2, kernelParam)
% X1 is a n1*m matrix
% X2 is a n2*m matrix
% n1, n2 is the data number, m is dimension

if isequal(kernelParam.name, 'rbf')
    gamma = kernelParam.gamma;    
    X1Norm = dot(X1, X1, 2);
    X2Norm = dot(X2, X2, 2);
    % the square of euclidean distance
    K = bsxfun(@plus, X1Norm, X2Norm') - 2*(X1*X2');
    K = exp((-gamma)*K);
elseif isequal(kernelParam.name, 'polynomial')
    d = kernelParam.deg;
    K = (X1 * X2').^d;
end
