function [x, g, nIter, flag] = ISPVNKernel(K, gamma, epsilon, maxIter, maxIterInner, checkFreq)

fprintf('\n');
flag = 0;
n = size(K, 1);
x = ones(n,1)/n;
nIter = 0;
delta = sqrt(x'*K*x) / gamma;


for i = 1 : maxIter
%     delta = sqrt(x'*K*x) / gamma;
    fprintf('\nDelta = %f\n', delta);
    [x, g, innerIter, flag] = SPVNKernel(x, K, delta, maxIterInner, checkFreq);
    nIter = nIter + innerIter;
    if flag == 1
        fprintf('\nDFP is feasible!\nIterations: %d\n', nIter);
        break;
    end
    if flag == 2
        if delta < epsilon            
            fprintf('\nAP is epsilon-feasible!\nIterations: %d\n', nIter);
            break;
        end
    end
    
    delta_new = sqrt(x'*K*x) / gamma;
    if abs(delta_new-delta) < 1e-6 || (delta_new > delta)
        fprintf('\nKISPVN fails!\n');
        flag = 0;
        break;
    end
    
    delta = delta_new;
    
end