function [x, y, nIter, flag] = ISPVN(A, gamma, epsilon, maxIter, maxIterInner, checkFreq)

fprintf('\n');
flag = 0;
[m,n] = size(A);
x = ones(n,1)/n;
nIter = 0;
delta = norm(A*x,2) / gamma;


for i = 1 : maxIter
%     delta = norm(A*x,2) / gamma;
    fprintf('\nDelta = %f\n', delta);
    [x, y, innerIter, flag] = SPVN(x, A, delta, maxIterInner, checkFreq);
    nIter = nIter + innerIter;
    if flag == 1
        fprintf('\nDFP is feasible!\nIterations: %d\n', nIter);
        break;
    end
    if flag == 2
        if delta < epsilon
            fprintf('\nAP is epsilon-feasible!\nIterations: %d\n', nIter);
            break;
        end
    end
    
    delta_new = norm(A*x,2) / gamma;
    if abs(delta_new-delta) < 1e-6 || (delta_new > delta)
        fprintf('\nISPVN fails!\n');
        flag = 0;
        break;
    end
    
    delta = delta_new;
    
end