function [res] = GenerateInfeasibleSystem(nn,theta)
% We need nn > 2 and theta>1
% The resulting size of the matrix will be n x m = 2^nn x 2^(nn-1)
% res.A stores the matrix generated 
% res.x stores the feasible solution for this matrix
n=power(2,nn);
m=floor((n-1)/2);

% Generate a Hadamard matrix
H0=[1 1; 1 -1];
H=H0;
for (i=1:1:nn-1)
    H=kron(H0,H);
end
%Normalize the columns of H to have Euclidean norm = 1
q=sqrt(diag(H'*H));
q=inv(diag(q));
H = H * q;
res.H=H;

res.theta=theta;
res.delta=1/theta
S=1:m;
for (k=0:1:m-1)
    S(k+1) = cos(pi*k/(m-1));
end
Smin=min(S);
Smax=max(S);
T = (res.delta-Smin*(1-res.delta)/(Smax-Smin))*ones(1,m)+(1-res.delta)/(Smax-Smin)*S;  
T = sqrt(T);
%sort(T)
res.S=S;
res.T=T;
if n-1-2*m>0,
    SS = [T -T ones(1,n-1-2*m)];
else
    SS = [T -T];
end
B = diag(SS);

res.x = GenerateRandomSolution(n);
%Find r, q such that Ax=0 where A is defined below
f = res.H(1,1); 
q = zeros(n-1,1);
z = res.H*res.x;
q = -1/f*B*z(2:n);
r = 1/(f*f)*z(2:n)'*B*z(2:n);
res.A = H'* [r q'; q B] * H;
norm(res.A*res.x,2)
%Normalize A matrix to make sure that each column has Euclidean norm 1 and
%update x to remain feasible to the normalized A matrix
p=diag(sqrt(diag(res.A'*res.A)));
res.A=res.A*inv(p);
res.x=p*res.x;
%%
function [x] = GenerateRandomSolution(n)
x = rand(n,1);
x = x./norm(x,1);
%%