function A =  GenerateA(m, n, k, isNormal)


% when k>0, DFP is feasible,
% when k=0, AP is feasible,
% if isequal(type, 'DFP')
%     k = 1;
% elseif isequal(type, 'AP')
%     k = 0;
% else
%     error('Wrong generating type');
% end

% generate A
y = rand(m,1);
y = y/norm(y,2);
v = rand(n,1);
B = randn(m,n);
A = B + (k*y)*v' -y*(y'*B);

% normalize A
if isNormal
    normA = sqrt(sum(A.*A));
    for j = 1 : n
        A(:,j) = A(:,j) / normA(j);
    end
end