function y = EuProjSimplex(c)

% bisection
epsilon = 1e-10;

theta = 0.5;
maxC = max(c);
left = maxC-1;
right = maxC;
y = max(c - theta, 0);
delta = sum(y) - 1;
while abs(delta) > epsilon
    if delta > 0
        left = theta;
    else
        right = theta;
    end
    theta = (left+right)/2;
    y = max(c - theta, 0);
    delta = sum(y) - 1;
end
