/*@@@**************************************************************************
* \file  rigidMotionWidget
* \author Hernan Badino
* \date  Fri Jun 19 09:28:25 EDT 2009
* \notes 
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include "rigidMotionWidget.h"
#include <QSettings>

using namespace VIC;


CRigidMotionWidget::CRigidMotionWidget  ( QWidget *  m_parent_p)
        : QDialog (  m_parent_p )
{
    setupUi(this);
    setObjectName  ( "Rigid Motion Widget" );
    setWindowTitle ( "Rigid Motion Widget" );    

    QSettings qSettings;
    
    printf("------------- %f %s--------------\n", 
           qSettings.value("x rotation", 0.).toDouble(),
           qSettings.value("x rotation", 0.).toString().toStdString().c_str());
    
    qSettings.beginGroup( objectName() );

    setXRotation(qSettings.value("x rotation", 0.).toDouble());
    setYRotation(qSettings.value("y rotation", 0.).toDouble());
    setZRotation(qSettings.value("z rotation", 0.).toDouble());
    
    setXTranslation(qSettings.value("x translation", 0.).toDouble());
    setYTranslation(qSettings.value("y translation", 0.).toDouble());
    setZTranslation(qSettings.value("z translation", 0.).toDouble());

    qSettings.endGroup();

    connect(m_qsbRotX_p, SIGNAL(valueChanged(double)),
            this,        SLOT(reCalculateRotMatrix()));

    connect(m_qsbRotY_p, SIGNAL(valueChanged(double)),
            this,        SLOT(reCalculateRotMatrix()));

    connect(m_qsbRotZ_p, SIGNAL(valueChanged(double)),
            this,        SLOT(reCalculateRotMatrix()));

    connect(m_qsbTransX_p, SIGNAL(valueChanged(double)),
            this,          SLOT(reCalculateTransVector()));

    connect(m_qsbTransY_p, SIGNAL(valueChanged(double)),
            this,          SLOT(reCalculateTransVector()));

    connect(m_qsbTransZ_p, SIGNAL(valueChanged(double)),
            this,          SLOT(reCalculateTransVector()));

    connect(m_qsbScale_p, SIGNAL(valueChanged(double)),
            this,         SLOT(reCalculateRotMatrix()));

    reCalculateRotMatrix();
    reCalculateTransVector();
}

CRigidMotionWidget::~CRigidMotionWidget ( )
{
    QSettings qSettings;

    qSettings.beginGroup( objectName() );
    
    qSettings.setValue ("x rotation", getXRotation() );
    qSettings.setValue ("y rotation", getYRotation() );
    qSettings.setValue ("z rotation", getZRotation() );
    
    qSettings.setValue ("x translation", getXTranslation() );
    qSettings.setValue ("y translation", getYTranslation() );
    qSettings.setValue ("z translation", getZTranslation() );

    qSettings.endGroup();
}

void CRigidMotionWidget::reCalculateRotMatrix()
{
    m_rotation.loadIdentity();
    
    m_rotation.rotateX( getXRotation() );
    m_rotation.rotateY( getYRotation() );
    m_rotation.rotateZ( getZRotation() );

    m_rotation *= getScale();

    m_rotation.print();
}

void CRigidMotionWidget::reCalculateTransVector()
{
    m_translation.set (  getXTranslation(), 
                         getYTranslation(), 
                         getZTranslation() );
    m_translation.print();
}
