#ifndef __ZKSTEREOOP_H
#define __ZKSTEREOOP_H

/*@@@**************************************************************************
 ** @file  zkStereoOp.h
 * \date   Wed Apr  8 14:24:05 GMT 2009
 * \author Hernan Badino
 * \notes  
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include <math.h>

#include "operator.h"
#include "image.h"
#include "logger.h"
#include "velodyneStream.h"
#include "velodyne.h"

#include "zkStereo/h/zkStereo.h"
/* PROTOTYPES */

/* CONSTANTS */

namespace VIC
{
    /* PROTOTYPES */
    class  CRigidMotionWidget;


    class CZkStereoOp: public VIC::COperator
    {
        /// Constructor, Desctructors
    public:    
        
        /// Constructors.
        CZkStereoOp ( COperator * const f_parent_p = NULL );
        
        /// Virtual destructor.
        virtual ~CZkStereoOp ();

        /// Cycle event.
        virtual bool cycle();
    
        /// Show event.
        virtual bool show();
    
        /// Init event.
        virtual bool initialize();
    
        /// Reset event.
        virtual bool reset();
    
        /// Exit event.
        virtual bool exit();

    /// User Operation Events
    public:
        /// Key pressed in display.
        virtual void keyPressed (     CKeyEvent * f_event_p );

    /// Parameters.
    public:
        ADD_PARAM_ACCESS(bool,         m_compute_b,         Compute )
        ADD_PARAM_ACCESS(int,          m_minDisparity_i,    MinDisparity );
        ADD_PARAM_ACCESS(int,          m_maxDisparity_i,    MaxDisparity );
        ADD_PARAM_ACCESS(unsigned int, m_winRadL0_ui,       WinRadL0 );
        ADD_PARAM_ACCESS(unsigned int, m_winRadRCLn_ui,     WinRadRCLn );
        ADD_PARAM_ACCESS(unsigned int, m_winRadD_ui,        WinRadD );
        ADD_PARAM_ACCESS(unsigned int, m_numIterations_ui,  NumIterations );
        ADD_PARAM_ACCESS(float,        m_maxScaler_f,       MaxScaler );
        ADD_PARAM_ACCESS(bool,         m_useSAD_b,          UseSAD );
        ADD_PARAM_ACCESS(float,        m_minConfidence_f,   MinConfidence );

    /// Protected Help Methods.
    protected:
        
    /// Private Data Types
    private:

        /// CZKStereo object.
        CZKStereo               m_stereoOp;
        
        /// CZKStereo object.
        CFloatImage             m_dispImg;

        /// compute?
        bool                    m_compute_b;

        /// Min disparity.
        int                     m_minDisparity_i;

        /// Max disparity.
        int                     m_maxDisparity_i;

        /// Windows radius for L0 computation.
        unsigned int            m_winRadL0_ui;

        /// Windows radius for row and column for the computation of Ln.
        unsigned int            m_winRadRCLn_ui;

        /// Windows radius for disparity for the computation of Ln.
        unsigned int            m_winRadD_ui;
        
        /// Windows radius for disparity for the computation of Ln.
        unsigned int            m_numIterations_ui;

        /// Windows radius for disparity for the computation of Ln.
        float                   m_maxScaler_f;

        /// Windows radius for disparity for the computation of Ln.
        bool                    m_useSAD_b;

        /// Min confidence
        float                   m_minConfidence_f;
    };
}


#endif // __ZKSTEREOOP_H
