#ifndef __VELODYNEVIEWEROP_H
#define __VELODYNEVIEWEROP_H

/*@@@**************************************************************************
 ** \file  velodyneViewerOp.h
 * \date   Wed Apr  8 14:24:05 GMT 2009
 * \author Hernan Badino
 * \notes  
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include <math.h>

#include "operator.h"
#include "image.h"
#include "logger.h"
#include "3DRowVector.h"


/* CONSTANTS */

namespace VIC
{
    /* PROTOTYPES */

    /* CLASS DEFINITION */
    class CVelodyneViewerOp: public VIC::COperator
    {
    /// Public data type.
    public:    
        typedef enum
        {
            CEM_X = 0,
            CEM_Y,
            CEM_Z,
            CEM_RANGE,
            CEM_AZIMUTH,
            CEM_ELEVATION
        } EColorEncodeMode_t;
        

    /// Constructor, Desctructors
    public:    
        
        /// Constructors.
        CVelodyneViewerOp ( COperator * const f_parent_p = NULL );
        
        /// Virtual destructor.
        virtual ~CVelodyneViewerOp ();

        /// Cycle event.
        virtual bool cycle();
    
        /// Show event.
        virtual bool show();
    
        /// Init event.
        virtual bool initialize();
    
        /// Reset event.
        virtual bool reset();
    
        /// Exit event.
        virtual bool exit();

    /// User Operation Events
    public:
        /// Key pressed in display.
        virtual void keyPressed (     CKeyEvent * f_event_p );

        /// Mouse moved.
        virtual void mouseMoved (     CMouseEvent * f_event_p );

    /// Gets and sets.
    public:
        /// T
        ADD_PARAM_ACCESS(SRgba,               m_testColor,       TestColor )

        /// Min and max values for color encoding.
        ADD_PARAM_ACCESS(EColorEncodeMode_t,  m_encodeMode_e,    ColorEncodeMode )

    /// Protected Methods.
    protected:
        void transformPoint( C3DVector &fr_point, bool f_inverse_b = false );

    /// Protected Data Types
    protected:

    private:
        
        /// Scale for displaying birdview.
        S2D<float>                  m_birdViewScale;

        /// Scale for displaying birdview.
        S2D<float>                  m_birdViewOffset;

        /// Display size in screens.
        S2D<int>                    m_birdViewDispSize;

        /// Just testing color parameter.
        SRgba                       m_testColor;

        /// Color encoding mode.
        EColorEncodeMode_t          m_encodeMode_e;

        /// Color encoding type.
        CColorEncoding              m_colorEnc;

    /// Some const ids.
    private:   
    };
}


#endif // __VELODYNEVIEWEROP_H
