#ifndef __VELODYNEREADEROP_H
#define __VELODYNEREADEROP_H

/*@@@**************************************************************************
 ** \file  velodyneReaderOp.h
 * \date   Wed Apr  8 14:24:05 GMT 2009
 * \author Hernan Badino
 * \notes  
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include <math.h>

#include "operator.h"
#include "image.h"
#include "logger.h"
#include "velodyneStream.h"
#include "velodyne.h"

/* PROTOTYPES */

/* CONSTANTS */

namespace VIC
{
    /* PROTOTYPES */
    class  CRigidMotionWidget;


    class CVelodyneReaderOp: public VIC::COperator
    {
        /// Constructor, Desctructors
    public:    
        
        /// Constructors.
        CVelodyneReaderOp ( COperator * const f_parent_p = NULL );
        
        /// Virtual destructor.
        virtual ~CVelodyneReaderOp ();

        /// Cycle event.
        virtual bool cycle();
    
        /// Show event.
        virtual bool show();
    
        /// Init event.
        virtual bool initialize();
    
        /// Reset event.
        virtual bool reset();
    
        /// Exit event.
        virtual bool exit();

    /// User Operation Events
    public:
        /// Key pressed in display.
        virtual void keyPressed (     CKeyEvent * f_event_p );

    /// Dialogs.
    public:
        /// Get list of widgets generated by this operator.
        virtual std::vector<QWidget*> getWidgets( ) const;

    /// Parameters.
    public:
        ADD_PARAM_ACCESS(double,      m_deltaTime_d,    DeltaTime );
        ADD_PARAM_ACCESS(bool,        m_show3DPoints_b, Show3DPoints );
        ADD_PARAM_ACCESS(S2D<double>, m_roiTL,          RoiTL );
        ADD_PARAM_ACCESS(S2D<double>, m_roiSize,        RoiSize );
        

    /// Protected Help Methods.
    protected:
        void         applyTransformation();
        
    /// Private Data Types
    private:

        struct SIndex
        {
            unsigned int  filePos_ui;
            double        timeStamp_d;
            unsigned int  lines_ui;
        };

        /// Buffer for storing read data.
        unsigned int           m_bufferSize_ui;        

        /// Index of timestamps.
        std::vector<SIndex>    m_index_v;

        /// Buffer for storing read data.
         SVelodynePointData *  m_buffer_p;

        /// Stream of data.
        CVelodyneDataStream    m_stream;

        /// File of velodyne data
        FILE *                 m_file_p;

        /// Velodyne object for converting to Euclidean Coord. System.
        CVelodyne              m_velodyne;

        /// Qt Dialog
        CRigidMotionWidget *   m_dialog_p;

        /// Delta time to load from image position.
        double                 m_deltaTime_d;

        /// Show 3D Points.
        bool                   m_show3DPoints_b;

        /// ROI TL for 3D point display.
        S2D<double>            m_roiTL;

        /// ROI Size for 3D point display.
        S2D<double>            m_roiSize;
        
   };
}


#endif // __VELODYNEREADEROP_H
