#ifndef __VELODYNEBASEOP_H
#define __VELODYNEBASEOP_H

/*@@@**************************************************************************
 ** \file  velodyneBaseOp.h
 * \date   Wed Apr  8 14:24:05 GMT 2009
 * \author Hernan Badino
 * \notes  
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include <math.h>

#include "operator.h"
#include "logger.h"
#include "sphericalRangeImage.h"
#include "sriHolesFiller.h"


/* CONSTANTS */

namespace VIC
{
    /* PROTOTYPES */

    /* CLASS DEFINITION */
    class CVelodyneBaseOp: public VIC::COperator
    {
    /// Public data type.
    public:    
        typedef enum
        {
            CEM_X = 0,
            CEM_Y,
            CEM_Z,
            CEM_RANGE,
            CEM_AZIMUTH,
            CEM_ELEVATION
        } EColorEncodeMode_t;
        

    /// Constructor, Desctructors
    public:    
        
        /// Constructors.
        CVelodyneBaseOp ( COperator * const f_parent_p = NULL );
        
        /// Virtual destructor.
        virtual ~CVelodyneBaseOp ();

        /// Cycle event.
        virtual bool cycle();
    
        /// Show event.
        virtual bool show();
    
        /// Init event.
        virtual bool initialize();
    
        /// Reset event.
        virtual bool reset();
    
        /// Exit event.
        virtual bool exit();

    /// User Operation Events
    public:
        /// Key pressed in display.
        virtual void keyPressed (     CKeyEvent * f_event_p );

        /// Mouse moved.
        virtual void mouseMoved (     CMouseEvent * f_event_p );

    /// Gets and sets.
    public:
        /// Min and max values for color encoding.
        ADD_PARAM_ACCESS (bool,           m_fillHolesHor_b,          FillHolesHor );
        ADD_PARAM_ACCESS (bool,           m_fillHolesVert_b,         FillHolesVert );

        /// Min and max values for color encoding.
        //ADD_PARAM_ACCESS(EColorEncodeMode_t,  m_encodeMode_e,    ColorEncodeMode )

    /// Protected Methods.
    protected:
        void showBirdView ( );
        void showIntensifiedSRI ( );
        void computePtsInWorldAndImageCoordSystem ( );
        bool reprojectRangeImage();
        
    /// Protected Data Types
    protected:

    private:
        /// Spherical Range Image.
        CSphericalRangeImage        m_sri;
        
        /// Velodyne generated depth image.
        CSphericalRangeImage        m_repSri;

        /// Velodyne generated depth image.
        CDoubleImage                m_auxImg;

        /// Spherical Range Image.
        CSriHolesFiller             m_fillerOp;
        
        /// Fill Holes?
        bool                        m_fillHolesHor_b;

        /// Fill Holes?
        bool                        m_fillHolesVert_b;
        
        /// Color encoding type.
        CColorEncoding              m_colorEnc;

        /// Vector of Sensor 3D Points.
        C3DVectorImage              m_localVectorImg;

        /// Vector of World 3D Points.
        C3DVectorImage              m_worldVectorImg;

        /// Vector of Sensor 3D Points.
        C3DVectorImage              m_leftCamVectorImg;

        /// Bird View scale.
        S2D<double>                 m_birdViewScale;

        /// Bird View offset.
        S2D<double>                 m_birdViewOffset;

        /// Bird view display size.
        S2D<double>                 m_birdViewDispSize;

        /// Color image for showing Intensified SRI
        //CImage                      m_intensifiedSRI;

    /// Some const ids.
    private:   
    };
}


#endif // __VELODYNEBASEOP_H
