#ifndef __RIGIDMOTIONWIDGET_H
#define __RIGIDMOTIONWIDGET_H

/*@@@**************************************************************************
 ** \file  rigidMotionWidget
 * \date   Fri Jun 19 09:22:47 EDT 2009
 * \author Hernan Badino
 * \notes  
*******************************************************************************
******************************************************************************/

/* INCLUDES */

#include <QDialog>
#include <QDoubleSpinBox>

#include "ui_rigidMotionInput.h"
//#include <algorithm>
#include "3DRowVector.h"
#include "3DMatrix.h"

/* CONSTANTS */

namespace VIC
{
    class CRigidMotionWidget: public QDialog, private Ui::QRigidMotionInputDlg
    {
        Q_OBJECT

   /// Constructors / Destructor
   public:
        
        CRigidMotionWidget ( QWidget *  m_parent_p = NULL );
        virtual ~CRigidMotionWidget ( );

   /// Gets.
   public:
        double     getXRotation() const { return m_qsbRotX_p -> value(); }
        double     getYRotation() const { return m_qsbRotY_p -> value(); }
        double     getZRotation() const { return m_qsbRotZ_p -> value(); }

        double     getXTranslation() const { return m_qsbTransX_p -> value(); }
        double     getYTranslation() const { return m_qsbTransY_p -> value(); }
        double     getZTranslation() const { return m_qsbTransZ_p -> value(); }

        double     getScale ( ) const      { return m_qsbScale_p -> value();}

        void       setXRotation(double f_val_d )  { m_qsbRotX_p -> setValue ( f_val_d );}
        void       setYRotation(double f_val_d )  { m_qsbRotY_p -> setValue ( f_val_d );}
        void       setZRotation(double f_val_d )  { m_qsbRotZ_p -> setValue ( f_val_d );}

        void       setXTranslation(double f_val_d )  { m_qsbTransX_p -> setValue ( f_val_d );}
        void       setYTranslation(double f_val_d )  { m_qsbTransY_p -> setValue ( f_val_d );}
        void       setZTranslation(double f_val_d )  { m_qsbTransZ_p -> setValue ( f_val_d );}

        void       setScale (double f_val_d ) { m_qsbScale_p -> setValue ( f_val_d );}

        const C3DMatrix&  getRotationMatrix     ( ) const { return m_rotation; }
        const C3DVector&  getTranslationVector  ( ) const { return m_translation; }
        
    private slots:

    /// Recalculate transformation parameters.
    private slots:
        virtual void reCalculateRotMatrix();
        virtual void reCalculateTransVector();

    protected:
        C3DMatrix         m_rotation;
        C3DVector         m_translation;
        
       
    };
}



#endif // __RIGIDMOTIONWIDGET_H
