/*@@@**************************************************************************
* \file  windowListView
* \author Hernan Badino
* \date  Fri Jun 19 18:44:41 EDT 2009
* \notes 
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include <QSettings>

#include "windowListView.h"
#include "windowListItemModel.h"
#include "logger.h"

using namespace VIC;

CWindowListView::CWindowListView ( QWidget *                m_parent_p )
        : QListView (     m_parent_p )
{
    //initializeWindows();
    setModel ( (QAbstractItemModel *)
               new CWindowListModel ( &m_window_v ) );

}

CWindowListView::~CWindowListView()
{
}

void
CWindowListView::dataChanged( const QModelIndex & f_topLeft, 
                              const QModelIndex & /*f_bottomRight*/ )
{
    if (f_topLeft.row() >= (int)m_window_v.size())
    {
        logger::warn ("Unexpected error: the index is larger than the amount of items in the vector");        
    }
    
    QSettings qSettings;

    QString name_str = m_window_v[f_topLeft.row()] -> objectName();

    bool visible_b = !m_window_v[f_topLeft.row()] -> isVisible();

    m_window_v[f_topLeft.row()] -> setVisible ( visible_b );

    if ( visible_b )
    {
        m_window_v[f_topLeft.row()] -> restoreGeometry ( 
                qSettings.value(name_str + QString("/geometry")).toByteArray() );
    }
    else
    {
        qSettings.setValue(name_str + QString("/geometry"), 
                           m_window_v[f_topLeft.row()] -> saveGeometry());
    }
    
    qSettings.setValue( name_str + QString("/visible"), 
                        visible_b );       
}

void 
CWindowListView::insertWindow( QWidget * f_widget_p, bool f_showNow_b )
{
    if ( !f_widget_p ) return;

    QString name_str = f_widget_p -> objectName();

    /// Check if already inserted.
    for (unsigned int i = 0; i < m_window_v.size(); ++i)
    {
        if ( m_window_v[i] == f_widget_p )
            return;
    }    
    
    QSettings qSettings;
    f_widget_p -> setVisible ( false );
    
    f_widget_p -> restoreGeometry ( 
            qSettings.value(name_str + QString("/geometry")).toByteArray() );

    if ( f_showNow_b )
    {
        bool visible_b = qSettings.value(name_str + QString("/visible"), true).toBool();
        f_widget_p -> setVisible ( visible_b );
    }
    
    m_window_v.push_back ( f_widget_p );
}

void 
CWindowListView::showWindows ()
{
    for (unsigned int i = 0; i < m_window_v.size(); ++i)
    {
        QString name_str = m_window_v[i] -> objectName();

        QSettings qSettings;        
        bool visible_b = qSettings.value(name_str + QString("/visible"), true).toBool();
        m_window_v[i] -> setVisible ( visible_b );    
    }
}

void 
CWindowListView::saveWindowsGeometry () const
{
    QSettings qSettings;

    for (unsigned int i = 0; i < m_window_v.size(); ++i)
    {
        QString name_str = m_window_v[i] -> objectName();        
    
        qSettings.setValue( name_str + QString("/geometry"), m_window_v[i] -> saveGeometry());
        qSettings.setValue( name_str + QString("/visible"), m_window_v[i] -> isVisible() );
    }
}

void 
CWindowListView::clear ()
{
    m_window_v.clear();    
}

/* ////////////  Version History ///////////////
 *  $Log: windowListView.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
