/*@@@**************************************************************************
* \file  windowListItemModel
* \author Hernan Badino
* \date  Mon Apr 20 23:57:42 GMT 2009
* \notes 
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include <QWidget>

#include "windowListItemModel.h"
#include "logger.h"

using namespace VIC;

CWindowListModel::CWindowListModel ( std::vector<QWidget *> *  f_widgets_p,
                                     QObject *                 f_parent_p )
        : QAbstractListModel ( f_parent_p ),
          m_widgets_p (       f_widgets_p )
{
}

CWindowListModel::~CWindowListModel()
{
}
        
QVariant
CWindowListModel::data ( const QModelIndex &f_index, 
                         int                f_role_i) const
{
    unsigned int idx_ui = f_index.row();
    
    if ( ! f_index.isValid() ||
         (unsigned int) idx_ui >= m_widgets_p -> size() )
        return QVariant();

    if (f_role_i == Qt::CheckStateRole && f_index.column() == 0)
    {
        return (*m_widgets_p)[idx_ui] -> isVisible();
    }

    if ( f_role_i != Qt::DisplayRole )
        return QVariant();

    QString str = (*m_widgets_p)[idx_ui] -> objectName();

    return (*m_widgets_p)[idx_ui] -> objectName();
}

Qt::ItemFlags
CWindowListModel::flags ( const QModelIndex &f_index) const
{
    if (!f_index.isValid())
        return 0;

    Qt::ItemFlags flags_e = Qt::ItemIsEnabled | Qt::ItemIsSelectable | Qt::ItemIsDropEnabled;

    if (f_index.column() == 0)
        flags_e |= Qt::ItemIsUserCheckable;
    
    return flags_e;
}

int
CWindowListModel::rowCount    ( const QModelIndex 
                                & /* f_parent */ ) const
{
    return m_widgets_p -> size();
}

bool 
CWindowListModel::setData ( const QModelIndex & f_index, 
                            const QVariant    & f_value, 
                            int                 f_role_i )
{
    unsigned int idx_ui = f_index.row();
    
    switch( f_role_i )
    {
	case Qt::CheckStateRole:
        {
            printf ("f_value.toBool() %i (*m_widgets_p)[idx_ui] -> isVisible() %i\n", 
                    f_value.toBool(),
                    (*m_widgets_p)[idx_ui] -> isVisible());
            
            /// Check if value has really changed.
            //if ((*m_widgets_p)[idx_ui] -> isVisible() != f_value.toBool())
            //    return false;
            
            emit dataChanged(f_index, f_index);
            return true;
        }

	case Qt::EditRole:
        {
        }

        default:
        {
        }   
    }
    
    return false;
}

/* ////////////  Version History ///////////////
 *  $Log: windowListItemModel.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
