/*@@@**************************************************************************
* \file  uintParamEditor
* \author Hernan Badino
* \date  Mon Apr 27 16:05:38 EDT 2009
* \notes 
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include "uintParamEditor.h"

#include <QHBoxLayout>
#include <limits>

#include "uintEditor.h"

using namespace VIC;

CUIntParameterEditor::CUIntParameterEditor( CUIntParameter *  f_parameter_p,
                                            QWidget        *  f_parent_p )
        : CBaseParamEditorWidget ( f_parent_p ),
          m_editor_p (                   NULL ),
          m_parameter_p (       f_parameter_p )
{
    QSizePolicy sizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    sizePolicy.setHorizontalStretch(0);
    sizePolicy.setVerticalStretch(0);

    m_editor_p = new CUIntEditor (0, this );

    QGridLayout *layout_p = new QGridLayout( this );

    layout_p -> setMargin( 0 );    
    layout_p -> addWidget( m_editor_p );
    
    if ( not f_parameter_p ->getComment().empty() )
        m_editor_p -> setToolTip ( QString(f_parameter_p ->getComment().c_str() ) );
    
    m_editor_p -> setValue ( f_parameter_p -> getValue() );

    sizePolicy.setHeightForWidth(m_editor_p->sizePolicy().hasHeightForWidth());
    m_editor_p -> setSizePolicy ( sizePolicy );    
           
    connect( m_editor_p,   SIGNAL( valueChanged( unsigned int ) ),
             this,      SLOT(   updateParameter() ) );
}

CUIntParameterEditor::~CUIntParameterEditor ()
{}

void
CUIntParameterEditor::updateParameter()
{
    if ( m_parameter_p -> getValue() != m_editor_p -> getValue() )
    {
        m_parameter_p -> setValue( m_editor_p -> getValue() );
    }
    
}

bool
CUIntParameterEditor::updateWidget()
{
    if ( m_parameter_p -> getValue() != m_editor_p -> getValue() )
        m_editor_p -> setValue ( m_parameter_p -> getValue() );

    return true;
}


/* ////////////  Version History ///////////////
 *  $Log: uintParamEditor.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
