/*@@@**************************************************************************
 * \file  uintEditor
 * \author Hernan Badino
 * \date  Mon Apr 27 16:05:38 EDT 2009
 * \notes 
 *******************************************************************************
 ******************************************************************************/

/* INCLUDES */
#include "uintEditor.h"

#include <QLineEdit>
#include <QHBoxLayout>
#include <math.h>

using namespace VIC;

CUIntEditor::CUIntEditor( unsigned int   f_value_ui,
                          QWidget *      f_parent_p )
        : QWidget (               f_parent_p ),
          m_qle_p (                     NULL ),
          m_value_ui (            f_value_ui )
{
    QSizePolicy sizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    sizePolicy.setHorizontalStretch(0);
    sizePolicy.setVerticalStretch(0);

    m_qle_p = new QLineEdit ( this );

    sizePolicy.setHeightForWidth(m_qle_p->sizePolicy().hasHeightForWidth());
    m_qle_p -> setSizePolicy ( sizePolicy );    

    m_qle_p -> setText ( QString::number(m_value_ui) );    

    QGridLayout *layout_p = new QGridLayout( this );
    layout_p -> addWidget ( m_qle_p );
    
    connect( m_qle_p,   SIGNAL( editingFinished() ),
             this,      SLOT(   lineEditChanged() ) );
}

CUIntEditor::~CUIntEditor ()
{}

void
CUIntEditor::lineEditChanged()
{
    QString str = m_qle_p->text();
    bool ok;
    unsigned int newVal_ui = str.toUInt(&ok);

    if ( ok && newVal_ui != m_value_ui )
    {
        m_value_ui = newVal_ui;
        emit valueChanged( m_value_ui );
    }

    m_qle_p -> setText ( QString::number( m_value_ui ) );
}

bool
CUIntEditor::setValue( unsigned int f_value_ui )
{
    m_value_ui = f_value_ui;
    m_qle_p -> setText ( QString::number( m_value_ui ) );
    return true;
}

QSize CUIntEditor::sizeHint () const
{
    return QSize(10,10);
}

/* ////////////  Version History ///////////////
 *  $Log: uintEditor.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:14  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
