/*@@@**************************************************************************
* \file  stringParamEditor
* \author Hernan Badino
* \date  Mon Apr 27 16:05:38 EDT 2009
* \notes 
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include "stringParamEditor.h"

#include <QLineEdit>
#include <QHBoxLayout>

using namespace VIC;

CStringParameterEditor::CStringParameterEditor( CStringParameter *  f_parameter_p,
                                                QWidget        *  f_parent_p )
        : CBaseParamEditorWidget ( f_parent_p ),
          m_qle_p (                      NULL ),
          m_parameter_p (       f_parameter_p )
{
    m_qle_p = new QLineEdit( this );

    m_qle_p -> setText ( f_parameter_p -> getValue().c_str() );
    
    QHBoxLayout *layout_p = new QHBoxLayout( this );
    
    layout_p -> setMargin( 0 );    
    layout_p -> addWidget( m_qle_p );
    
    if ( not f_parameter_p ->getComment().empty() )
        m_qle_p -> setToolTip ( QString(f_parameter_p ->getComment().c_str() ) );
    
    connect( m_qle_p,   SIGNAL( editingFinished () ),
             this,      SLOT(   updateParameter() ) );
}

CStringParameterEditor::~CStringParameterEditor ()
{}

void
CStringParameterEditor::updateParameter()
{
    if ( m_parameter_p -> getValue() != m_qle_p -> text().toStdString() )
    {
        m_parameter_p -> setValue( m_qle_p -> text().toStdString() );
    }
}

bool
CStringParameterEditor::updateWidget()
{
    if ( m_parameter_p -> getValue() != m_qle_p -> text().toStdString() )
        m_qle_p -> setText( QString( m_parameter_p -> getValue().c_str() ) );
                             
    return true;
}


/* ////////////  Version History ///////////////
 *  $Log: stringParamEditor.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
