/*@@@**************************************************************************
* \file  stringParam
* \author Hernan Badino
* \date  Mon Apr 27 13:54:26 EDT 2009
* \notes 
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include "stringParam.h"
#include "stringOp.h"
#include "stringParamEditor.h"

using namespace VIC;

CStringParameter::CStringParameter ( std::string               f_name_str, 
                                     std::string               f_comment_str,
                                     std::string               f_value_str,
                                     CParameterBaseConnector * f_connector_p )
        : CParameter ( f_name_str, f_comment_str, f_connector_p ),
          m_str (                                   f_value_str )
{
    /// update string value.
    updateInitialValue();    
    update();
}

CStringParameter::~CStringParameter()
{}

std::string
CStringParameter::getStringFromValue ( ) const
{
    return m_str;
}


// Return true if the first word after elimintaing spaces is 
// is true or false or if the string contains a valid number.
// In any other case return false and no value is assigned.

bool
CStringParameter::setValueFromString ( std::string f_val_str )
{
    m_str = f_val_str;
    
    /// Else do not change nothing and return false.
    
    updateInitialValue();    
    return update();
}

std::string CStringParameter::getValue ( ) const
{
    return m_str;
}

bool
CStringParameter::setValue ( std::string f_value_str,
                             bool        f_shouldUpdate_b )
{
    if ( f_value_str == m_str )
        return true;

    m_str = f_value_str;
    
    if ( f_shouldUpdate_b )
        return update();

    return true;
}

::QWidget *
CStringParameter::createEditor ( )
{
    return  (m_qtEditor_p = new CStringParameterEditor ( this ));
}

/* ////////////  Version History ///////////////
 *  $Log: stringParam.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
