/*@@@**************************************************************************
* \file  seqDevTester
* \author Hernan Badino
* \date  Mon Mar 16 14:55:29 GMT 2009
* \notes 
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include "seqDevTester.h"
#include "seqDevTesterDlg.h"

#include <QTimer>

using namespace VIC;

CSeqDevTester::CSeqDevTester()
        : m_qtPlay_p (             NULL ),
          m_currentFrame_i (          0 ),
          m_backward_b (          false )
{
    m_dialog_p = new CSeqDevTesterDlg;

    m_qtPlay_p = new QTimer ( this );
    connect(m_qtPlay_p, SIGNAL(timeout()), this, SLOT(timeOut()));

    connect(m_dialog_p, SIGNAL(reset()), this, SLOT(stopAndEmitReset()));

    m_dialog_p -> show();
}

/*
CSeqDevTester::~CSeqDevTester()
{
}
*/

void
CSeqDevTester::stopAndEmitReset()
{
    printf("calling Stop\n");
    stop();
    emit reset();
}

void
CSeqDevTester::timeOut()
{
    if (m_backward_b)
        --m_currentFrame_i;
    else
        ++m_currentFrame_i;

    if ( m_currentFrame_i > m_dialog_p -> getNumberOfFrames())
        m_currentFrame_i = 1;

    if ( m_currentFrame_i < 1 )
         m_currentFrame_i = m_dialog_p -> getNumberOfFrames();

    emit cycle( );
}

bool
CSeqDevTester::nextFrame()
{
    ++m_currentFrame_i;

    if (m_currentFrame_i > m_dialog_p -> getNumberOfFrames())
        m_currentFrame_i = 1;
    
    return true;
}

bool
CSeqDevTester::prevFrame()
{
    --m_currentFrame_i;

    if (m_currentFrame_i < 1)
        m_currentFrame_i = m_dialog_p -> getNumberOfFrames();

    return true;
}

bool
CSeqDevTester::goToFrame( int f_frameNumber_i )
{
    if ( f_frameNumber_i < 1 ||
         f_frameNumber_i > m_dialog_p -> getNumberOfFrames() )
        return false;
    
    m_currentFrame_i = f_frameNumber_i;

    return true;
}

bool
CSeqDevTester::stop()
{
    m_currentFrame_i = 0;
    m_currentState_e = S_PAUSED;
    // Stop timer.
    m_qtPlay_p -> stop();    
    return true;
}

bool
CSeqDevTester::startPlaying()
{
    m_currentState_e = S_PLAYING;
    m_backward_b = false;

    if ( not m_qtPlay_p -> isActive() )
        m_qtPlay_p -> start(1);

    return true;
}

bool
CSeqDevTester::startPlayingBackward()
{
    m_currentState_e = S_PLAYING_BACKWARD;
    m_backward_b = true;

    if ( not m_qtPlay_p -> isActive() )
        m_qtPlay_p -> start(1);

    return true;
}

bool
CSeqDevTester::pause()
{
    m_currentState_e = S_PAUSED;
    m_qtPlay_p -> stop();
    return true;
}

int
CSeqDevTester::getNumberOfFrames() const
{
    return m_dialog_p -> getNumberOfFrames();
}

int
CSeqDevTester::getCurrentFrame() const
{
    return m_currentFrame_i;
}

bool
CSeqDevTester::isBidirectional() const
{
    return m_dialog_p -> isBidirectional();
}


bool
CSeqDevTester::registerOutputs (
        std::map< std::string, CIOObj* > &fr_map )
{
    char txt[16];

    for ( int i = 0 ; 
          i < m_dialog_p -> getNumberOfImagesPerFrame(); ++i)
    {
        sprintf(txt, "Image %04i", i);
        m_output_p[i] = i * 1000.f + m_currentFrame_i;

        fr_map[txt] = m_output_p + i;
    }

     
    const std::string frameNr_str = "Frame Number";
    static CIO_ui32 imgNr = m_currentFrame_i;

    fr_map[ frameNr_str ] = &imgNr;

   return true;
}

std::vector<QDialog *> 
CSeqDevTester::getDialogs ( ) const
{
    std::vector<QDialog *> vec;
    vec.push_back( m_dialog_p  );
    return vec;
}
        


/* ////////////  Version History ///////////////
 *  $Log: seqDevTester.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
