/*@@@**************************************************************************
 * \file  seqControler
 * \author Hernan Badino
 * \date  Wed Mar  4 15:39:49 Local time zone must be set--see zic manual page 2009
 * \notes 
 *******************************************************************************
 ******************************************************************************/

/* INCLUDES */
#include <QObject>

#include "seqControler.h"
#include "seqControlDlg.h"
#include "seqDeviceControl.h"

using namespace VIC;

/// Constructor
CSeqControler::CSeqControler( CSeqDeviceControl * const f_device_p )
        : m_controlDlg_p (                   NULL ),
          m_deviceCtrl_p (             f_device_p )
{
    m_controlDlg_p = new CSeqControlDlg ( NULL );
    
    /// Make it invisible. The window manager will show it if necessary.
    m_controlDlg_p -> setVisible ( false );
    m_controlDlg_p -> setObjectName ( tr("Control Dialog") );

    /// Connections between the control dialog and "this".
    connect(m_controlDlg_p, SIGNAL(stop()), this, SLOT(stopClicked()));
    connect(m_controlDlg_p, SIGNAL(play()), this, SLOT(playClicked()));
    connect(m_controlDlg_p, SIGNAL(playBackward()), this, SLOT(playBackwardClicked()));
    connect(m_controlDlg_p, SIGNAL(pause()), this, SLOT(pauseClicked()));
    connect(m_controlDlg_p, SIGNAL(previous()), this, SLOT(previousClicked()));
    connect(m_controlDlg_p, SIGNAL(next()), this, SLOT(nextClicked()));
    connect(m_controlDlg_p, SIGNAL(begin()), this, SLOT(beginClicked()));
    connect(m_controlDlg_p, SIGNAL(end()), this, SLOT(endClicked()));
    connect(m_controlDlg_p, SIGNAL(goTo(int)), this, SLOT(goTo(int)));

    if ( m_deviceCtrl_p )
    {
        if ( m_deviceCtrl_p -> getState() == CSeqDeviceControl::S_PLAYING )
            m_controlDlg_p -> setActionMode ( CSeqControlDlg::AM_PLAY );
        else if (m_deviceCtrl_p -> getState() == CSeqDeviceControl::S_PAUSED )
            m_controlDlg_p -> setActionMode ( CSeqControlDlg::AM_PAUSE );
        else
            m_controlDlg_p -> setActionMode ( CSeqControlDlg::AM_PLAY_BACKWARD );

    
        /// Connections between device and this.
        connect(m_deviceCtrl_p, SIGNAL(cycle()), this, SLOT(playCycle()));
        connect(m_deviceCtrl_p, SIGNAL(reset()), this, SLOT(reset()));
    }

    //m_controlDlg_p -> show();
}

/// Destructor
CSeqControler::~CSeqControler()
{
    if (!m_controlDlg_p -> parent())
        delete m_controlDlg_p;
}

void
CSeqControler::start()
{
    bool result_b;
    
    result_b = m_deviceCtrl_p -> initialize();

    refreshControlDlg();

    if (result_b)
    {
        emit initialize();
    }
}

void
CSeqControler::stopClicked()
{
    bool result_b;
    
    m_deviceCtrl_p -> stop();

    m_controlDlg_p -> setActionMode ( CSeqControlDlg::AM_PAUSE );

    result_b = m_deviceCtrl_p -> goToFirstFrame();

    refreshControlDlg();

    if (result_b)
    {
        emit stop();
    }
}

void
CSeqControler::playClicked()
{
    bool result_b;
    
    result_b = m_deviceCtrl_p -> startPlaying();

    m_controlDlg_p -> setActionMode ( CSeqControlDlg::AM_PLAY );
}

void
CSeqControler::playBackwardClicked()
{
    bool result_b;
    
    result_b = m_deviceCtrl_p -> startPlayingBackward();

    m_controlDlg_p -> setActionMode ( CSeqControlDlg::AM_PLAY_BACKWARD );
}

void
CSeqControler::playCycle()
{
    refreshControlDlg();

    emit cycle();
}

void
CSeqControler::pauseClicked()
{
    bool result_b;
    
    result_b = m_deviceCtrl_p -> pause();

    m_controlDlg_p -> setActionMode ( CSeqControlDlg::AM_PAUSE );
}

void
CSeqControler::previousClicked()
{
    bool result_b;
    
    result_b = m_deviceCtrl_p -> prevFrame();

    refreshControlDlg();

    if (result_b)
    {
        emit cycle();
    }
}

void
CSeqControler::nextClicked()
{
    bool result_b;
    
    result_b = m_deviceCtrl_p -> nextFrame();

    refreshControlDlg();

    if (result_b)
    {
        emit cycle();
    }
}

void
CSeqControler::beginClicked()
{
    bool result_b;
    
    result_b = m_deviceCtrl_p -> goToFirstFrame();

    refreshControlDlg();

    if (result_b)
    {
        emit cycle();
    }
}

void
CSeqControler::endClicked()
{
    bool result_b;
    
    result_b = m_deviceCtrl_p -> goToLastFrame();

    refreshControlDlg();

    if (result_b)
    {
        emit cycle();
    }
}

void
CSeqControler::goTo ( const int f_framNumber_i )
{
    bool result_b;
    
    result_b = m_deviceCtrl_p -> goToFrame (f_framNumber_i);

    refreshControlDlg();

    if (result_b)
    {
        emit cycle();
    }
}

void
CSeqControler::reset()
{
    m_controlDlg_p -> setActionMode ( CSeqControlDlg::AM_PAUSE );
    refreshControlDlg();

    emit reset();
}

void
CSeqControler::refreshControlDlg()
{
    const int frames_i    = m_deviceCtrl_p -> getNumberOfFrames();
    const int currFrame_i = m_deviceCtrl_p -> getCurrentFrame();

    if ( m_deviceCtrl_p -> isBidirectional() )
        m_controlDlg_p -> setDeviceType ( CSeqControlDlg::DT_BIDIRECTIONAL );
    else
        m_controlDlg_p -> setDeviceType ( CSeqControlDlg::DT_FORWARD_ONLY );

    m_controlDlg_p -> setNumberOfFrames ( frames_i    );
    m_controlDlg_p -> setCurrentFrame   ( currFrame_i );

    //m_controlDlg_p -> setPositionMode
}

QDialog * 
CSeqControler::getDialog() const
{ 
    return m_controlDlg_p;
}

/* ////////////  Version History ///////////////
 *  $Log: seqControler.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
