/*@@@**************************************************************************
 * \file  rectList.cpp
 * \author Hernan Badino
 * \date  Thu Feb 26 16:14:22 Local time zone must be set--see zic manual page 2009
 * \notes 
 *******************************************************************************
 ******************************************************************************/

/* INCLUDES */
#include "rectList.h"

#include "glheader.h"


using namespace VIC;


CRectangleList::CRectangleList( int /* f_bufferSize_i */ )
{}

/// Destructor.
CRectangleList::~CRectangleList()
{}


// Add rectangles from other list.
bool
CRectangleList::add ( const CRectangleList &f_otherList )
{
    m_rect_v.insert( m_rect_v.begin(), 
                     f_otherList.m_rect_v.begin(),
                     f_otherList.m_rect_v.end() );
    return true;
}

// Add empty rectangles.
bool
CRectangleList::add ( float   f_u1_f, 
                           float   f_v1_f,
                           float   f_u2_f,
                           float   f_v2_f,
                           SRgba   f_color,
                           float   f_lineWidth_i )
{
    SRectangle newRect;

    newRect.outlineColor = f_color;

    /// Make transparent filling.
    newRect.fillColor.a  = 0;

    newRect.u1_f         = f_u1_f;
    newRect.u2_f         = f_u2_f;
    newRect.v1_f         = f_v1_f;
    newRect.v2_f         = f_v2_f;
    newRect.lineWidth_f  = f_lineWidth_i;

    m_rect_v.push_back(newRect);

    return true;
}

// Add a filled rectangle.
bool
CRectangleList::add (  float   f_u1_f, 
                            float   f_v1_f,
                            float   f_u2_f,
                            float   f_v2_f,
                            SRgba   f_outLineColor,
                            SRgba   f_fillColor,
                            float   f_lineWidth_i )
{
    SRectangle newRect;

    newRect.outlineColor = f_outLineColor;
    newRect.fillColor    = f_fillColor;
    newRect.u1_f         = f_u1_f;
    newRect.u2_f         = f_u2_f;
    newRect.v1_f         = f_v1_f;
    newRect.v2_f         = f_v2_f;
    newRect.lineWidth_f  = f_lineWidth_i;

    m_rect_v.push_back(newRect);

    return true;
}

// Clear rectangle list.
bool
CRectangleList::clear ()
{
    m_rect_v.clear();
    return m_rect_v.size() == 0;
}

// Draw all rectangles.
bool
CRectangleList::show () const
{
    std::vector< SRectangle >::const_iterator last = m_rect_v.end();

    for (std::vector< SRectangle >::const_iterator i = m_rect_v.begin(); 
         i != last; ++i )
    {
        glLineWidth( i->lineWidth_f );
        
        /// If not complete transparent.
        if ( i->fillColor.a != 0 )
        {
            glColor4ub( i->fillColor.r, 
                        i->fillColor.g, 
                        i->fillColor.b, 
                        i->fillColor.a );
            
            glBegin(GL_POLYGON);
            glVertex2f ( i->u1_f, i->v1_f );
            glVertex2f ( i->u2_f, i->v1_f );
            glVertex2f ( i->u2_f, i->v2_f );
            glVertex2f ( i->u1_f, i->v2_f );
            glEnd();
        }       

        glColor4ub( i->outlineColor.r, 
                    i->outlineColor.g, 
                    i->outlineColor.b, 
                    i->outlineColor.a );
        
        glBegin ( GL_LINE_LOOP ) ;
        glVertex2f ( i->u1_f, i->v1_f );
        glVertex2f ( i->u2_f, i->v1_f );
        glVertex2f ( i->u2_f, i->v2_f );
        glVertex2f ( i->u1_f, i->v2_f );
        glEnd();

    }

    /// Todo: Check GL status and return value.
    return true;
}

bool
CRectangleList::write ( FILE*                f_file_p,
                             const float          f_offsetU_f /* = 0.0 */,
                             const float          f_offsetV_f /* = 0.0 */,
                             const std::string    f_parameters_str /* = "" */) const
{
    return CDrawingElementList::write( f_file_p, 
                                       f_offsetU_f, 
                                       f_offsetV_f, 
                                       f_parameters_str );
}

/// Return number of elements.
int
CRectangleList::getSize () const
{
    return m_rect_v.size();    
}


/* ////////////  Version History ///////////////
 *  $Log: rectList.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
