/*@@@**************************************************************************
* \file  parameter
* \author Hernan Badino
* \date  Mon Apr 27 12:11:04 EDT 2009
* \notes 
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include <QWidget>
#include "parameter.h"
#include "paramBaseConnector.h"

using namespace VIC;

CParameter::CParameter ( std::string f_name_str, 
                         std::string f_comment_str,
                         CParameterBaseConnector * f_connector_p )
  : m_name_str  (             f_name_str ),
    m_comment_str  (       f_comment_str ),
    m_qtEditor_p (                  NULL ),
    m_connector_p (        f_connector_p )
{
    if (m_connector_p)
        m_connector_p -> setParameterObject ( this );
}

CParameter::~CParameter()
{
    if ( m_connector_p )
        delete m_connector_p;
}


CParameterBaseConnector * 
CParameter::setConnector ( CParameterBaseConnector * f_connector_p )
{
    m_connector_p = f_connector_p;    

    if (m_connector_p)
        m_connector_p -> setParameterObject ( this );

    return m_connector_p;    
}

CParameterBaseConnector * 
CParameter::getConnector (  ) const
{
    return m_connector_p;
}

bool
CParameter::update()
{
    if ( m_qtEditor_p ) 
        m_qtEditor_p -> updateWidget();

    bool res_b;
    
    if ( m_connector_p )
    {
        res_b = m_connector_p -> updateContainer();
    }
    
    else
        res_b = true;
    
    return res_b;
}

bool
CParameter::updateFromContainer()
{
    if ( m_connector_p )
        return m_connector_p -> updateParameterObj();
    else
        return true;
}


/* ////////////  Version History ///////////////
 *  $Log: parameter.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
