/*@@@**************************************************************************
 * \file  lineList.cpp
 * \author Hernan Badino
 * \date  Thu Feb 26 16:14:22 Local time zone must be set--see zic manual page 2009
 * \notes 
 *******************************************************************************
 ******************************************************************************/

/* INCLUDES */
#include "lineList.h"

#include "glheader.h"


using namespace VIC;


CLineList::CLineList( int /* f_bufferSize_i */ )
{}

/// Destructor.
CLineList::~CLineList()
{}

// Add lines from other list.
bool
CLineList::add ( const CLineList &f_otherList )
{
    m_line_v.insert( m_line_v.begin(), 
                     f_otherList.m_line_v.begin(),
                     f_otherList.m_line_v.end() );

    return true;
}

// Draw all lines.
bool
CLineList::add ( float   f_u1_f, 
                      float   f_v1_f,
                      float   f_u2_f,
                      float   f_v2_f,
                      SRgba   f_color,
                      float   f_lineWidth_i )
{
    SLine newLine;

    newLine.color       = f_color;
    newLine.u1_f        = f_u1_f;
    newLine.u2_f        = f_u2_f;
    newLine.v1_f        = f_v1_f;
    newLine.v2_f        = f_v2_f;
    newLine.lineWidth_f = f_lineWidth_i;

    m_line_v.push_back(newLine);

    return true;
}

// Clear all lines.
bool
CLineList::clear ()
{
    m_line_v.clear();
    return m_line_v.size() == 0;
}

// Draw all lines.
bool
CLineList::show () const
{
    std::vector< SLine >::const_iterator last = m_line_v.end();

    for (std::vector< SLine >::const_iterator i = m_line_v.begin(); 
         i != last; ++i )
    {   
        glLineWidth( i->lineWidth_f );
        glColor4ub(i->color.r, i->color.g, i->color.b, i->color.a);

        glBegin(GL_LINES);
        glVertex2f(i->u1_f, i->v1_f);
        glVertex2f(i->u2_f, i->v2_f);
        glEnd();
    }

    /// Todo: Check GL status and return value.
    return true;
}

bool
CLineList::write ( FILE*                f_file_p,
                        const float          f_offsetU_f /* = 0.0 */,
                        const float          f_offsetV_f /* = 0.0 */,
                        const std::string    f_parameters_str /* = "" */) const
{
    return CDrawingElementList::write( f_file_p, 
                                       f_offsetU_f, 
                                       f_offsetV_f, 
                                       f_parameters_str );
}

/// Return number of elements.
int
CLineList::getSize () const
{
    return m_line_v.size();    
}


/* ////////////  Version History ///////////////
 *  $Log: lineList.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
