/*@@@**************************************************************************
* \file  intParamEditor
* \author Hernan Badino
* \date  Mon Apr 27 16:05:38 EDT 2009
* \notes 
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include "intParamEditor.h"

#include <QHBoxLayout>
#include <limits>

#include "intEditor.h"

using namespace VIC;

CIntParameterEditor::CIntParameterEditor( CIntParameter *  f_parameter_p,
                                            QWidget        *  f_parent_p )
        : CBaseParamEditorWidget ( f_parent_p ),
          m_qsb_p (                      NULL ),
          m_parameter_p (       f_parameter_p )
{
    QSizePolicy sizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    sizePolicy.setHorizontalStretch(0);
    sizePolicy.setVerticalStretch(0);

    m_qsb_p = new CIntEditor (0, this );

    QGridLayout *layout_p = new QGridLayout( this );

    layout_p -> setMargin( 0 );    
    layout_p -> addWidget( m_qsb_p );
    
    if ( not f_parameter_p ->getComment().empty() )
        m_qsb_p -> setToolTip ( QString(f_parameter_p ->getComment().c_str() ) );
    
    m_qsb_p -> setValue ( f_parameter_p -> getValue() );

    sizePolicy.setHeightForWidth(m_qsb_p->sizePolicy().hasHeightForWidth());
    m_qsb_p -> setSizePolicy ( sizePolicy );    
           
    connect( m_qsb_p,   SIGNAL( valueChanged(     int ) ),
             this,      SLOT(   updateParameter() ) );
}

CIntParameterEditor::~CIntParameterEditor ()
{}

void
CIntParameterEditor::updateParameter()
{
    if ( m_parameter_p -> getValue() != m_qsb_p -> getValue() )
    {
        m_parameter_p -> setValue( m_qsb_p -> getValue() );
    }
    
}

bool
CIntParameterEditor::updateWidget()
{
    if ( m_parameter_p -> getValue() != m_qsb_p -> getValue() )
        m_qsb_p -> setValue ( m_parameter_p -> getValue() );

    return true;
}


/* ////////////  Version History ///////////////
 *  $Log: intParamEditor.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:14  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
