/*@@@**************************************************************************
* \file  intParam
* \author Hernan Badino
* \date  Mon Apr 27 13:54:26 EDT 2009
* \notes 
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include "intParam.h"
#include "stringOp.h"
#include "intParamEditor.h"

#include <math.h>
#include <errno.h>
#include <stdlib.h>

using namespace VIC;

CIntParameter::CIntParameter ( std::string               f_name_str, 
                               std::string               f_comment_str,
                               int                       f_value_i,
                               CParameterBaseConnector * f_connector_p )
        : CParameter ( f_name_str, f_comment_str, f_connector_p ),
          m_val_i (                    f_value_i )
{
    /// update string value.
    CParameter::updateInitialValue();
    
    update();
}

CIntParameter::~CIntParameter()
{}

std::string
CIntParameter::getStringFromValue ( ) const
{
    return CStringOp::numToString<int> ( m_val_i );
}


// Return true if the first word after elimintaing spaces is 
// is true or false or if the string contains a valid number.
// In any other case return false and no value is assigned.

bool
CIntParameter::setValueFromString ( std::string f_val_str )
{
    if (f_val_str.length() == 0)
        return false;
    
    CStringOp::trimLeft ( f_val_str );

    const char* begin_p = f_val_str.c_str();
    char* end_p   = NULL;
    errno = 0;
    double val_d = strtod ( begin_p, &end_p );
    
    if ( end_p != begin_p && 
         isfinite(val_d) &&
         !errno )
    {
        m_val_i = (int)val_d;

        updateInitialValue();
        return update();
    }
    
    /// Else do not change nothing and return false.
    return false;
}

int 
CIntParameter::getValue ( ) const
{
    return m_val_i;
}

bool CIntParameter::setValue ( int  f_value_b,
                               bool f_shouldUpdate_b )
{
    if ( f_value_b == m_val_i )
        return true;

    m_val_i = f_value_b;

    if ( f_shouldUpdate_b )
        return update();

    return true;    
}

::QWidget *
CIntParameter::createEditor ( )
{
    return  (m_qtEditor_p = new CIntParameterEditor ( this ));
}


/* ////////////  Version History ///////////////
 *  $Log: intParam.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
