/*@@@**************************************************************************
 * \file  intEditor
 * \author Hernan Badino
 * \date  Mon Apr 27 16:05:38 EDT 2009
 * \notes 
 *******************************************************************************
 ******************************************************************************/

/* INCLUDES */
#include "intEditor.h"

#include <QLineEdit>
#include <QHBoxLayout>
#include <math.h>

using namespace VIC;

CIntEditor::CIntEditor( int        f_value_i,
                        QWidget *     f_parent_p )
        : QWidget (               f_parent_p ),
          m_qle_p (                     NULL ),
          m_value_i (              f_value_i )
{
    QSizePolicy sizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    sizePolicy.setHorizontalStretch(0);
    sizePolicy.setVerticalStretch(0);

    m_qle_p = new QLineEdit ( this );

    sizePolicy.setHeightForWidth(m_qle_p->sizePolicy().hasHeightForWidth());
    m_qle_p -> setSizePolicy ( sizePolicy );    

    m_qle_p -> setText ( QString::number(m_value_i) );    

    QGridLayout *layout_p = new QGridLayout( this );
    layout_p -> addWidget ( m_qle_p );
    
    connect( m_qle_p,   SIGNAL( editingFinished() ),
             this,      SLOT(   lineEditChanged() ) );
}

CIntEditor::~CIntEditor ()
{}

void
CIntEditor::lineEditChanged()
{
    QString str = m_qle_p->text();
    bool ok;
    int newVal_i = str.toInt(&ok);

    if ( ok && newVal_i != m_value_i )
    {
        m_value_i = newVal_i;
        emit valueChanged( m_value_i );
    }

    m_qle_p -> setText ( QString::number( m_value_i ) );
}

bool
CIntEditor::setValue( int f_value_i )
{
    m_value_i = f_value_i;
    m_qle_p -> setText ( QString::number( m_value_i ) );
    return true;
}

QSize CIntEditor::sizeHint () const
{
    return QSize(10,10);
}

/* ////////////  Version History ///////////////
 *  $Log: intEditor.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
