/*@@@**************************************************************************
 * \file  stringParamEditor
 * \author Hernan Badino
 * \date  Mon Apr 27 16:05:38 EDT 2009
 * \notes 
 *******************************************************************************
 ******************************************************************************/

/* INCLUDES */
#include "int2DParamEditor.h"

#include <QLabel>
#include <QHBoxLayout>

#include "intEditor.h"

using namespace VIC;

CInt2DParameterEditor::CInt2DParameterEditor( CInt2DParameter *  f_parameter_p,
                                              QWidget *          f_parent_p )
        : CBaseParamEditorWidget ( f_parent_p ),
          m_parameter_p (       f_parameter_p )
{    
    QSizePolicy sizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Fixed);
    sizePolicy.setHorizontalStretch(0);
    sizePolicy.setVerticalStretch(0);

    QHBoxLayout *layout_p = new QHBoxLayout( this );    
    layout_p -> setMargin( 0 );    

    const std::string * names_p = f_parameter_p -> getNames();

    /// Sping boxes now.
    for (int i = 0; i < 2; ++i)
    {
        m_qsb_p[i] = new CIntEditor( 0, this );
        m_qsb_p[i] -> setSizePolicy ( sizePolicy );
        if (not names_p[i].empty() )
        {    
            layout_p -> addWidget(new QLabel( names_p[i].c_str(), this ));
        }

        layout_p -> addWidget( m_qsb_p[i] );
    }

    updateWidget();

    connect( m_qsb_p[0],  SIGNAL( valueChanged ( int ) ),
             this,        SLOT(   updateParameter() ) );

    connect( m_qsb_p[1],  SIGNAL( valueChanged ( int ) ),
             this,        SLOT(   updateParameter() ) );
}

CInt2DParameterEditor::~CInt2DParameterEditor ()
{}

void
CInt2DParameterEditor::updateParameter()
{
    S2D<int> value( m_qsb_p[0]->getValue(),
                    m_qsb_p[1]->getValue() );
    

    if ( not (m_parameter_p -> getValue() == value ) )
        m_parameter_p -> setValue( value );
}

bool
CInt2DParameterEditor::updateWidget()
{
    S2D<int> value = m_parameter_p -> getValue();

    m_qsb_p[0] -> setValue(value.x);
    m_qsb_p[1] -> setValue(value.y);

    return true;    
}


/* ////////////  Version History ///////////////
 *  $Log: int2DParamEditor.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
