/*@@@**************************************************************************
 * \file  floatParam
 * \author Hernan Badino
 * \date  Mon Apr 27 13:54:26 EDT 2009
 * \notes 
 *******************************************************************************
 ******************************************************************************/

/* INCLUDES */
#include <QWidget>
#include "floatParam.h"
#include "stringOp.h"
#include "floatParamEditor.h"

#include <math.h>
#include <errno.h>
#include <stdlib.h>
#include <limits>

using namespace VIC;

CFloatParameter::CFloatParameter ( std::string               f_name_str, 
                                   std::string               f_comment_str,
                                   float                     f_value_f,
                                   CParameterBaseConnector * f_connector_p )
        : CParameter ( f_name_str, f_comment_str, f_connector_p ),
          m_value_f (                  f_value_f )
{
    /// update string value.
    CParameter::updateInitialValue();
    update();
}

CFloatParameter::~CFloatParameter()
{}

std::string
CFloatParameter::getStringFromValue ( ) const
{
    return CStringOp::numToString<float> ( m_value_f, 0, std::numeric_limits<float>::digits );
}

bool
CFloatParameter::setValueFromString ( std::string f_val_str )
{
    if (f_val_str.length() == 0)
        return false;
    
    CStringOp::trimLeft ( f_val_str );

    const char* begin_p = f_val_str.c_str();
    char* end_p   = NULL;
    errno = 0;
    double val_d = strtod ( begin_p, &end_p );
    
    if ( end_p != begin_p && 
         isfinite(val_d) &&
         !errno )
    {
        m_value_f = (float)val_d;
        updateInitialValue();
        return update();
    }
    
    /// Else do not change nothing and return false.
    return false;
}

float CFloatParameter::getValue ( ) const
{
    return m_value_f;
}

bool CFloatParameter::setValue ( float f_value_f,
                                 bool  f_shouldUpdate_b )
{
    if ( f_value_f == m_value_f )
        return true;

    m_value_f = f_value_f;

    if ( f_shouldUpdate_b )
        return update();

    return true;
}

::QWidget *
CFloatParameter::createEditor ( )
{
    return  (m_qtEditor_p = new CFloatParameterEditor ( this ));
}

/* ////////////  Version History ///////////////
 *  $Log: floatParam.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
