/*@@@**************************************************************************
* \file  floatParamEditor
* \author Hernan Badino
* \date  Mon Apr 27 16:05:38 EDT 2009
* \notes 
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include "enumParamEditor.h"

#include <QComboBox>
#include <QHBoxLayout>
#include <limits>

using namespace VIC;

CEnumParameterEditor::CEnumParameterEditor( CEnumParameterBase *  f_parameter_p,
                                            QWidget *             f_parent_p )
        : CBaseParamEditorWidget ( f_parent_p ),
          m_qcb_p (                      NULL ),
          m_parameter_p (       f_parameter_p )
{
    m_qcb_p = new QComboBox( this );

    QHBoxLayout *layout_p = new QHBoxLayout( this );

    layout_p -> setMargin( 0 );    
    layout_p -> addWidget( m_qcb_p );
    
    if ( not f_parameter_p ->getComment().empty() )
        m_qcb_p -> setToolTip ( QString(f_parameter_p ->getComment().c_str() ) );

    m_qcb_p->setEditable ( false );
    
    int currIdx_i = 0;
    
    for (int i = 0; i < f_parameter_p -> getCount(); ++i)
    {
        std::string str;
        int val_i;

        m_parameter_p -> getPair ( i, val_i, str );
        m_qcb_p -> addItem ( str.c_str(), QVariant(val_i) );

        if (val_i == m_parameter_p->getIntValue())
            currIdx_i = i;
    }

    m_qcb_p -> setCurrentIndex ( currIdx_i );
    
    connect( m_qcb_p,   SIGNAL( currentIndexChanged ( int  ) ),
             this,      SLOT(   updateParameter() ) );
}

CEnumParameterEditor::~CEnumParameterEditor ()
{}

void
CEnumParameterEditor::updateParameter()
{
    int val_i = m_qcb_p -> itemData( m_qcb_p -> currentIndex() ).toInt();
    
    if ( m_parameter_p -> getIntValue() != val_i )
    {
        printf("Value changed to %i\n", val_i);
        
        m_parameter_p -> setValueFromInt ( val_i );
    }
    
}

bool
CEnumParameterEditor::updateWidget()
{
    int val_i = m_qcb_p -> itemData( m_qcb_p -> currentIndex() ).toInt();

    if ( m_parameter_p -> getIntValue() != val_i  )
    {    
        int currIdx_i = -1;
        
        for (int i = 0; m_parameter_p -> getCount(); ++i)
        {
            std::string str;
            int val_i;
            
            m_parameter_p -> getPair ( i, val_i, str  );
            m_qcb_p -> addItem ( str.c_str(), QVariant(val_i) );
            
            if (val_i == m_parameter_p->getIntValue())
            {
                currIdx_i = i;
                break;
            }
        }

        if (currIdx_i == -1)
            return false;
        
        m_qcb_p -> setCurrentIndex ( currIdx_i );
    }

    return true;
}


/* ////////////  Version History ///////////////
 *  $Log: enumParamEditor.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
