/*@@@**************************************************************************
* \file  doubleParamEditor
* \author Hernan Badino
* \date  Mon Apr 27 16:05:38 EDT 2009
* \notes 
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include "doubleParamEditor.h"

#include <QHBoxLayout>
#include <limits>

#include "doubleEditor.h"

using namespace VIC;

const unsigned int CDoubleParameterEditor::m_maxDecimals_cui = 12;

CDoubleParameterEditor::CDoubleParameterEditor( CDoubleParameter *  f_parameter_p,
                                                QWidget *           f_parent_p )
        : CBaseParamEditorWidget ( f_parent_p ),
          m_qdsb_p (                     NULL ),
          m_parameter_p (       f_parameter_p )
{
    m_qdsb_p = new CDoubleEditor( 0., this );

    QHBoxLayout *layout_p = new QHBoxLayout( this );

    layout_p -> setMargin( 0 );
    layout_p -> addWidget( m_qdsb_p );
    
    if ( not f_parameter_p ->getComment().empty() )
        m_qdsb_p -> setToolTip ( QString(f_parameter_p ->getComment().c_str() ) );
   
    double value_d =  (double)(f_parameter_p -> getValue());    
    /// (double)std::numeric_limits<float>::min() is not working therefore:
    //double min_d   = -(double)std::numeric_limits<double>::max();
    //double max_d   = (double)std::numeric_limits<double>::max();
    
    //double min_d   = -1.e15;
    //double max_d   =  1.e15;

    
    m_qdsb_p -> setDecimals (m_maxDecimals_cui );
    /*
    m_qdsb_p -> setMinimum ( min_d );
    m_qdsb_p -> setMaximum ( max_d );
    */
    m_qdsb_p -> setValue ( value_d );

    printf("HMin = %i HMax = %i WMin = %i WMax = %i\n",
           m_qdsb_p->minimumHeight(),
           m_qdsb_p->maximumHeight(),
           m_qdsb_p->minimumWidth(),
           m_qdsb_p->maximumWidth() );

    connect( m_qdsb_p,   SIGNAL( valueChanged(  double ) ),
             this,       SLOT(   updateParameter() ) );
}

CDoubleParameterEditor::~CDoubleParameterEditor ()
{}

void
CDoubleParameterEditor::updateParameter()
{
    if ( m_parameter_p -> getValue() != m_qdsb_p -> getValue() )
    {
        m_parameter_p -> setValue( m_qdsb_p -> getValue() );
    }
    
}

bool
CDoubleParameterEditor::updateWidget()
{
    if ( m_parameter_p -> getValue() != m_qdsb_p -> getValue() )
        m_qdsb_p -> setValue ( m_parameter_p -> getValue() );

    return true;
}


/* ////////////  Version History ///////////////
 *  $Log: doubleParamEditor.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
