/*@@@**************************************************************************
 * \file  doubleParam
 * \author Hernan Badino
 * \date  Tue Jun 23 08:56:13 EDT 2009
 * \notes 
 *******************************************************************************
 ******************************************************************************/

/* INCLUDES */
#include "doubleParam.h"
#include "stringOp.h"
#include "doubleParamEditor.h"

#include <math.h>
#include <errno.h>
#include <stdlib.h>
#include <limits>

using namespace VIC;

CDoubleParameter::CDoubleParameter ( std::string               f_name_str, 
                                     std::string               f_comment_str,
                                     double                    f_value_d,
                                     CParameterBaseConnector * f_connector_p )
        : CParameter ( f_name_str, f_comment_str, f_connector_p ),
          m_value_d (                  f_value_d )
{
    /// update string value.
    CParameter::updateInitialValue();
    update();
}

CDoubleParameter::~CDoubleParameter()
{}

std::string
CDoubleParameter::getStringFromValue ( ) const
{
    return CStringOp::numToString<double> ( m_value_d,  0, std::numeric_limits<float>::digits );
}

bool
CDoubleParameter::setValueFromString ( std::string f_val_str )
{
    if (f_val_str.length() == 0)
        return false;
    
    CStringOp::trimLeft ( f_val_str );

    const char* begin_p = f_val_str.c_str();
    char* end_p   = NULL;
    errno = 0;
    double val_d = strtod ( begin_p, &end_p );
    
    if ( end_p != begin_p && 
         isfinite(val_d) &&
         !errno )
    {
        m_value_d = (double)val_d;
        updateInitialValue();
        return update();
    }
    
    /// Else do not change nothing and return false.
    return false;
}

double
CDoubleParameter::getValue ( ) const
{
    printf("Returning value %lf\n", m_value_d);
    
    return m_value_d;
}

bool 
CDoubleParameter::setValue ( double f_value_d,
                             bool   f_shouldUpdate_b  )
{
    if ( f_value_d == m_value_d )
        return true;

    m_value_d = f_value_d;

    if ( getEditor() )
        ((::QWidget*)getEditor()) -> update();

    if ( f_shouldUpdate_b )
        return update();
    return true;
}

::QWidget *
CDoubleParameter::createEditor ( )
{
    return  (m_qtEditor_p = new CDoubleParameterEditor ( this ));
}

/* ////////////  Version History ///////////////
 *  $Log: doubleParam.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
