/*@@@**************************************************************************
* \file  doubleEditor
* \author Hernan Badino
* \date  Mon Apr 27 16:05:38 EDT 2009
* \notes 
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include "doubleEditor.h"

#include <QLineEdit>
#include <QHBoxLayout>
#include <math.h>

using namespace VIC;

CDoubleEditor::CDoubleEditor( double        f_value_d,
                              QWidget *     f_parent_p )
        : QWidget (               f_parent_p ),
          m_qle_p (                     NULL ),
          m_value_d (              f_value_d ),
          m_maxDecimals_ui (              25 )
{
    QSizePolicy sizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    sizePolicy.setHorizontalStretch(0);
    sizePolicy.setVerticalStretch(0);

    m_qle_p = new QLineEdit ( this );

    sizePolicy.setHeightForWidth(m_qle_p->sizePolicy().hasHeightForWidth());
    m_qle_p -> setSizePolicy ( sizePolicy );    

    m_qle_p -> setText ( QString::number(m_value_d, 'g', m_maxDecimals_ui ) );    

    QGridLayout *layout_p = new QGridLayout( this );
    layout_p -> addWidget ( m_qle_p );
    
    connect( m_qle_p,   SIGNAL( editingFinished() ),
             this,      SLOT(   lineEditChanged() ) );
}

CDoubleEditor::~CDoubleEditor ()
{}

void
CDoubleEditor::lineEditChanged()
{
    QString str = m_qle_p->text();
    bool ok;
    double newVal_d = str.toDouble(&ok);

    if ( ok && fabs(newVal_d - m_value_d) > 1.e-11 )
    {
        m_value_d = newVal_d;
        emit valueChanged( m_value_d );
    }

    m_qle_p -> setText ( QString::number(m_value_d, 'g', m_maxDecimals_ui ) );
}

bool
CDoubleEditor::setValue( double f_value_d )
{
    m_value_d = f_value_d;
    m_qle_p -> setText ( QString::number(m_value_d, 'g', m_maxDecimals_ui ) );
    return true;
}

QSize CDoubleEditor::sizeHint () const
{
    return QSize(10,10);
}

/* ////////////  Version History ///////////////
 *  $Log: doubleEditor.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
