/*@@@**************************************************************************
* \file  displayTreeNode
* \author Hernan Badino
* \date  Mon Apr 13 14:18:34 GMT 2009
* \notes 
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include "displayTreeNode.h"
#include "drawingList.h"

using namespace VIC;


CDisplayOpNode::CDisplayOpNode ( COperator *                 f_op_p,
                                 CDisplayTreeNodeAbstract *  f_parent_p )
        : CDisplayTreeNodeAbstract (      f_parent_p  ),
          m_operator_p (                       f_op_p )
{
}

CDisplayOpNode::~CDisplayOpNode ( )
{
    for (unsigned int i = 0; i < m_opChildren.size(); ++i)
    {
        delete m_opChildren[i];
    }    

    m_opChildren.clear();

    for (unsigned int i = 0; i < m_displayChildren.size(); ++i)
    {
        delete m_displayChildren[i];
    }    

    m_displayChildren.clear();
}

void
CDisplayOpNode::appendChild(  CDisplayOpNode *  f_child_p )
{
    /// Ensure parentship.
    if ( f_child_p == NULL ) return;
    f_child_p -> m_parent_p = this;

    m_opChildren.push_back (  f_child_p );
}

void
CDisplayOpNode::appendChild(  CDisplayNode *  f_child_p )
{
    /// Ensure parentship.
    if ( f_child_p == NULL ) return;
    f_child_p -> m_parent_p = this;

    m_displayChildren.push_back (  f_child_p );
}


////////////////////////////

CDisplayTreeNodeAbstract *  
CDisplayOpNode::getChild ( unsigned int f_number_ui ) const
{
    if (f_number_ui < m_opChildren.size())
        return m_opChildren[f_number_ui];

    f_number_ui -= m_opChildren.size();
    
    if ( f_number_ui < m_displayChildren.size())
        return m_displayChildren[f_number_ui];

    return NULL;
}

CDisplayOpNode *
CDisplayOpNode::getOpChild (const COperator * const f_op_p ) const
{    
    for (unsigned int i = 0; i < m_opChildren.size(); ++i)
    {
        if ( m_opChildren[i] -> m_operator_p == f_op_p )
            return m_opChildren[i];
    }

    return NULL;
}

CDisplayOpNode *
CDisplayOpNode::getOpChild ( const unsigned int f_number_ui ) const
{
    if (f_number_ui < m_opChildren.size())
        return m_opChildren[f_number_ui];

    return NULL;    
}


CDisplayNode *
CDisplayOpNode::getDisplayChild (const std::string & f_name_str ) const
{    
    for (unsigned int i = 0; i < m_displayChildren.size(); ++i)
    {
        if ( m_displayChildren[i] -> getName() == f_name_str )
            return m_displayChildren[i];
    }

    return NULL;
}

CDisplayNode *
CDisplayOpNode::getDisplayChild (const unsigned int f_number_ui ) const
{
    if (f_number_ui < m_displayChildren.size())
        return m_displayChildren[f_number_ui];

    return NULL;    
}


/* ////////////  Version History ///////////////
 *  $Log: displayTreeNode.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
