/*@@@**************************************************************************
 * \file  displayTreeWidget
 * \author Hernan Badino
 * \date  Tue Apr 14 17:04:52 GMT 2009
 * \notes 
 *******************************************************************************
 ******************************************************************************/

/* INCLUDES */
#include <QGridLayout>
//#include <QGLWidget>
#include <QPushButton>

#include "displayTreeDlg.h"
#include "displayTreeItemModel.h"
#include "displayTreeNode.h"


using namespace VIC;

CDisplayTreeDlg::CDisplayTreeDlg  ( QWidget *           f_parent_p,
                                    QGLWidget *         f_shareGLWidget_p,
                                    CDisplayOpNode *    f_rootNode_p )
        : QDialog (                      f_parent_p ),
          m_treeItemModel_p (                  NULL )
{
    setWindowTitle ( tr("Drawing Lists") );
    setObjectName  ( windowTitle() );

    /// Tree View
    m_qtvDisplays_p = new CDisplayTreeView( this, f_shareGLWidget_p );
    m_qtvDisplays_p->setObjectName(QString::fromUtf8("Display Tree View Object"));

    /// Tree View Model
    m_treeItemModel_p = new CDisplayTreeItemModel ( f_rootNode_p );
    m_qtvDisplays_p -> setModel ( m_treeItemModel_p );

    
    /// Expand all button.
    QPushButton *pushButton1_p = new QPushButton(this);
    pushButton1_p->setObjectName(QString::fromUtf8("ExpandAllPushButton"));
    pushButton1_p->setText(tr("Expand All"));
    connect(pushButton1_p, SIGNAL(clicked(bool)), m_qtvDisplays_p, SLOT(expandAll()));

    /// Collapse all button.
    QPushButton *pushButton2_p = new QPushButton(this);
    pushButton2_p->setObjectName(QString::fromUtf8("CollapseAllPushButton"));
    pushButton2_p->setText(tr("Collapse All"));
    connect(pushButton2_p, SIGNAL(clicked(bool)), m_qtvDisplays_p, SLOT(collapseAll()));   
    
    /// Layout
    QGridLayout * gridLayout_p = new QGridLayout(this);

    gridLayout_p->setObjectName(QString::fromUtf8("GridLayout"));

    gridLayout_p->addWidget(pushButton1_p, 0, 0, 1, 1);
    gridLayout_p->addWidget(pushButton2_p, 0, 1, 1, 1);
    gridLayout_p->addWidget(m_qtvDisplays_p, 1, 0, 1, 2);

    m_qtvDisplays_p -> loadParameters ( );
    m_qtvDisplays_p -> expandAll ( );
}

CDisplayTreeDlg::~CDisplayTreeDlg ()
{
    if ( m_treeItemModel_p )
        delete m_treeItemModel_p;

    m_treeItemModel_p = NULL;
}

/* ////////////  Version History ///////////////
 *  $Log: displayTreeDlg.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
